package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.KeywordsType;
import com.zzsn.event.vo.KeywordsTypeVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 关键词类别
 * @Author: jeecg-boot
 * @Date: 2021-12-01
 * @Version: V1.0
 */
@Mapper
public interface KeywordsTypeMapper extends BaseMapper<KeywordsType> {

    /**
     * 编辑节点状态
     *
     * @param id
     * @param status
     */
    void updateTreeNodeStatus(@Param("id") String id, @Param("status") String status);

    /**
     * 获取关键词类别列表
     *
     * @author lkg
     */
    List<KeywordsTypeVo> listAll();

    List<KeywordsTypeVo> listAll(@Param("userId") String userId,@Param("customerId") String customerId);
}
