package com.zzsn.event.util;

import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.*;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * excel导出工具类
 *
 * @author 李东亮
 * @date 2014-6-23 下午6:05:49
 * @company 郑州怡晟电子商务有限公司
 */
public class ExcelExportUtil {

	/**
	 * 获取标题栏样式
	 *
	 * @param workbook
	 * @return
	 */
	private static HSSFCellStyle getTitleStyle(HSSFWorkbook workbook) {
		// 生成一个样式
		HSSFCellStyle style = workbook.createCellStyle();
		// 设置这些样式
//		style.setFillForegroundColor(HSSFColor.WHITE.index);
		style.setFillForegroundColor(IndexedColors.WHITE.getIndex());
		style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
		style.setBorderBottom(BorderStyle.THIN);
		style.setBorderLeft(BorderStyle.THIN);
		style.setBorderRight(BorderStyle.THIN);
		style.setBorderTop(BorderStyle.THIN);
		style.setAlignment(HorizontalAlignment.CENTER);
		// style.setDataFormat(HSSFDataFormat.getBuiltinFormat("0.00"));
		// 生成一个字体
		HSSFFont font = workbook.createFont();
		font.setColor(IndexedColors.DARK_TEAL.index);
		font.setFontHeightInPoints((short) 12);
//		font.setBold(true);
		font.setBold(true);
		// 把字体应用到当前的样式
		style.setFont(font);
		return style;
	}
	/**
	 * 获取标题栏样式
	 *
	 * @param workbook
	 * @return
	 */
	public static HSSFCellStyle getHeaderStyle(HSSFWorkbook workbook) {
		// 生成一个样式
		HSSFCellStyle style = workbook.createCellStyle();
		// 设置这些样式
		style.setFillForegroundColor(IndexedColors.SKY_BLUE.index);
		style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
		style.setBorderBottom(BorderStyle.THIN);
		style.setBorderLeft(BorderStyle.THIN);
		style.setBorderRight(BorderStyle.THIN);
		style.setBorderTop(BorderStyle.THIN);
		style.setAlignment(HorizontalAlignment.CENTER);
		// style.setDataFormat(HSSFDataFormat.getBuiltinFormat("0.00"));
		// 生成一个字体
		HSSFFont font = workbook.createFont();
		font.setColor(IndexedColors.BLACK.index);
		font.setFontHeightInPoints((short) 9);
//		font.setBold(true);
		font.setBold(true);
		// 把字体应用到当前的样式
		style.setFont(font);
		return style;
	}

	/**
	 * 获取字符串型内容栏样式
	 *
	 * @param workbook
	 * @return
	 */
	public static HSSFCellStyle getRowStrStyle(HSSFWorkbook workbook) {
		// 生成一个样式
		HSSFCellStyle style = workbook.createCellStyle();
		// 设置这些样式
		//style.setAlignment(HSSFCellStyle.ALIGN_LEFT);
		style.setBorderBottom(BorderStyle.THIN);
		style.setBorderLeft(BorderStyle.THIN);
		style.setBorderRight(BorderStyle.THIN);
		style.setBorderTop(BorderStyle.THIN);
		style.setAlignment(HorizontalAlignment.CENTER);
		// 生成一个字体
		HSSFFont font = workbook.createFont();
		font.setColor(IndexedColors.BLACK.index);
		font.setFontHeightInPoints((short) 9);
		font.setBold(true);
		// 把字体应用到当前的样式
		style.setFont(font);
		return style;
	}

	/**
	 * 获取数字型内容栏样式
	 *
	 * @param workbook
	 * @param digit
	 *            小数位数
	 * @return
	 */
	private static HSSFCellStyle getRowNumStyle(HSSFWorkbook workbook, int digit) {
		// 生成一个样式
		HSSFCellStyle style = workbook.createCellStyle();
		// 设置这些样式
		style.setAlignment(HorizontalAlignment.RIGHT);
		String format = "0";
		for (int i = 0; i < digit; i++) {
			if (i == 0) {
				format += ".0";
			} else {
				format += "0";
			}
		}
		HSSFDataFormat dataFormat = workbook.createDataFormat();
		style.setDataFormat(dataFormat.getFormat(format));
		// 生成一个字体
		HSSFFont font = workbook.createFont();
		font.setColor(IndexedColors.DARK_BLUE.index);
		font.setFontHeightInPoints((short) 9);
		font.setBold(true);
		// 把字体应用到当前的样式
		style.setFont(font);
		return style;
	}

	/**
	 * 导出EXCEL
	 *
	 * @param title
	 * @param headers
	 * @param data
	 * @return
	 */
	public static HSSFWorkbook export(String title, List<String> headers, List<List<String>> data) {
		HSSFWorkbook workbook = new HSSFWorkbook();
		HSSFSheet sheet = workbook.createSheet(title);
		sheet.setDefaultColumnWidth(20);
		HSSFCellStyle titleStyle = ExcelExportUtil.getHeaderStyle(workbook);
		// 产生表格标题行
		HSSFRow row = sheet.createRow(0);
		row.setHeight((short) 400);
		HSSFCell cell;
		for (int i = 0; i < headers.size(); i++) {
			cell = row.createCell(i, CellType.STRING);
			cell.setCellStyle(titleStyle);
			cell.setCellValue(new HSSFRichTextString(headers.get(i)));
		}
		// 数据行
		List<String> rowData;
		for (int m = 0; m < data.size(); m++) {
			rowData = data.get(m);
			row = sheet.createRow(m + 1);
			row.setHeight((short) 400);
			for (int n = 0; n < rowData.size(); n++) {
				cell = row.createCell(n, CellType.STRING);
				cell.setCellValue(rowData.get(n));
			}
		}
		return workbook;
	}



	/**
	 * 创建cell
	 * @param rowStrStyle
	 * @param row
	 * @param index
	 * @param value
	 */
	private static void createCell(HSSFCellStyle rowStrStyle, HSSFRow row, int index , String value){
		HSSFCell cell = row.createCell(index, CellType.STRING);
		cell.setCellStyle(rowStrStyle);
		cell.setCellValue(value);
	}
	/**
	 * 创建cell
	 * @param rowStrStyle
	 * @param row
	 * @param index
	 * @param value
	 */
	private static void createCell(HSSFCellStyle rowStrStyle, HSSFRow row, int index , Long value){
		HSSFCell cell = row.createCell(index, CellType.STRING);
		cell.setCellStyle(rowStrStyle);
		String v = value==null?"":value.toString();
		cell.setCellValue(v);
	}

	/**
	 * 读取excel数据
	 *
	 * @param firstRow  第一行有用数据(0表示第一行)
	 * @param columnNum 有用数据的总列数
	 * @return java.util.List<java.util.List < java.lang.String>>
	 */
	public static List<List<String>> readExcel(InputStream inputStream, Integer firstRow, Integer columnNum) throws Exception {
		List<List<String>> dataList = new ArrayList<>();
		//获取整个excel
		XSSFWorkbook hb = new XSSFWorkbook(inputStream);
		int sheets = hb.getNumberOfSheets();
		for (int i = 0; i < sheets; i++) {
			XSSFSheet sheet = hb.getSheetAt(i);
			//第一行
			int firstRowNum = sheet.getFirstRowNum();
			//最后一行
			int lastRowNum = sheet.getPhysicalNumberOfRows();
			for (int j = firstRowNum + firstRow; j < lastRowNum; j++) {
				//获取行
				XSSFRow row = sheet.getRow(j);
				if (row != null) {
					List<String> list = new ArrayList<>();
					for (int m = 0; m < columnNum; m++) {
						String data = ExcelExportUtil.getValue(row.getCell(m)).trim();
						list.add(data);
					}
					dataList.add(list);
				}
			}
		}

		return dataList;
	}


	public static HSSFWorkbook exportData(List<String> keyList, List<List<String>> rows, String filename) {
		HSSFWorkbook workbook = new HSSFWorkbook();
		HSSFSheet sheet = workbook.createSheet(filename);
		sheet.setDefaultColumnWidth(20);
		sheet.setDefaultRowHeight((short) 400);
		HSSFCellStyle titleStyle = ExcelExportUtil.getHeaderStyle(workbook);
		HSSFCellStyle rowStrStyle = ExcelExportUtil.getRowStrStyle(workbook);
		// 产生表格标题行
		HSSFRow row = sheet.createRow(0);
		row.setHeight((short) 400);
		HSSFCell cell;
		List<String> colData = new ArrayList<>(keyList);
		for (int i = 0; i < colData.size(); i++) {
			cell = row.createCell(i, CellType.STRING);
			cell.setCellStyle(titleStyle);
			cell.setCellValue(new XSSFRichTextString(colData.get(i)));
		}
		// 数据行
		for (int m = 0; m < rows.size(); m++) {
			List<String>  rowData = rows.get(m);
			row = sheet.createRow(m + 1);
			row.setHeight((short) 400);
			int i=0;
			for (String rowDatum : rowData) {
				createCell(rowStrStyle, row, i, rowDatum);
				i++;
			}
		}
		return workbook;
	}

	//单个sheet
	public static XSSFWorkbook exportExcelData(List<String> keyList, List<List<String>> rows, String sheetName) {
		XSSFWorkbook workbook = new XSSFWorkbook();
		Sheet sheet = workbook.createSheet(sheetName);
		sheet.setDefaultColumnWidth(20);
		sheet.setDefaultRowHeight((short) 400);
		XSSFCellStyle titleStyle = ExcelExportUtil.getHeaderStyle(workbook);
		XSSFCellStyle rowStrStyle = ExcelExportUtil.getRowStrStyle(workbook);
		// 产生表格标题行
		Row row = sheet.createRow(0);
		row.setHeight((short) 400);
		Cell cell;
        List<String> colData = new ArrayList<>(keyList);
		for (int i = 0; i < colData.size(); i++) {
			cell = row.createCell(i, CellType.STRING);
			cell.setCellStyle(titleStyle);
			cell.setCellValue(new XSSFRichTextString(colData.get(i)));
		}
		// 数据行
		for (int m = 0; m < rows.size(); m++) {
			List<String>  rowData = rows.get(m);
			row = sheet.createRow(m + 1);
			row.setHeight((short) 400);
			int i=0;
            for (String rowDatum : rowData) {
                createCell(rowStrStyle, row, i, rowDatum);
                i++;
            }
		}
		return workbook;
	}

	//多个sheet
	public static void exportExcelData(XSSFWorkbook workbook, int sheetNum, List<String> keyList, List<List<String>> rows, String filename) {
		Sheet sheet = workbook.createSheet();
		//多个sheet
		workbook.setSheetName(sheetNum,filename);
		sheet.setDefaultColumnWidth(20);
		sheet.setDefaultRowHeight((short) 400);
		XSSFCellStyle titleStyle = ExcelExportUtil.getHeaderStyle(workbook);
		XSSFCellStyle rowStrStyle = ExcelExportUtil.getRowStrStyle(workbook);
		// 产生表格标题行
		Row row = sheet.createRow(0);
		row.setHeight((short) 400);
		Cell cell;
		List<String> colData = new ArrayList<>(keyList);
		for (int i = 0; i < colData.size(); i++) {
			cell = row.createCell(i, CellType.STRING);
			cell.setCellStyle(titleStyle);
			cell.setCellValue(new XSSFRichTextString(colData.get(i)));
		}
		// 数据行
		for (int m = 0; m < rows.size(); m++) {
			List<String>  rowData = rows.get(m);
			row = sheet.createRow(m + 1);
			row.setHeight((short) 400);
			int i=0;
			for (String rowDatum : rowData) {
				createCell(rowStrStyle, row, i, rowDatum);
				i++;
			}
		}
	}


	private static void createCell(XSSFCellStyle rowStrStyle, Row row, int index , String value){
		Cell cell = row.createCell(index, CellType.STRING);
		cell.setCellStyle(rowStrStyle);
		cell.setCellValue(value);
	}
	private static XSSFCellStyle getHeaderStyle(XSSFWorkbook workbook) {
		// 生成一个样式
		XSSFCellStyle style = workbook.createCellStyle();
		// 设置这些样式
		style.setFillForegroundColor(IndexedColors.SKY_BLUE.index);
		style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
		style.setBorderBottom(BorderStyle.THIN);
		style.setBorderLeft(BorderStyle.THIN);
		style.setBorderRight(BorderStyle.THIN);
		style.setBorderTop(BorderStyle.THIN);
		style.setAlignment(HorizontalAlignment.CENTER);
		// style.setDataFormat(HSSFDataFormat.getBuiltinFormat("0.00"));
		// 生成一个字体
		XSSFFont font = workbook.createFont();
		font.setColor(IndexedColors.BLACK.index);
		font.setFontHeightInPoints((short) 9);
//		font.setBold(true);
		font.setBold(true);
		// 把字体应用到当前的样式
		style.setFont(font);
		return style;
	}
	private static XSSFCellStyle getRowStrStyle(XSSFWorkbook workbook) {
		// 生成一个样式
		XSSFCellStyle style = workbook.createCellStyle();
		// 设置这些样式
		//style.setAlignment(HSSFCellStyle.ALIGN_LEFT);
		style.setBorderBottom(BorderStyle.THIN);
		style.setBorderLeft(BorderStyle.THIN);
		style.setBorderRight(BorderStyle.THIN);
		style.setBorderTop(BorderStyle.THIN);
		style.setAlignment(HorizontalAlignment.CENTER);
		// 生成一个字体
		XSSFFont font = workbook.createFont();
		font.setColor(IndexedColors.BLACK.index);
		font.setFontHeightInPoints((short) 9);
		font.setBold(true);
		// 把字体应用到当前的样式
		style.setFont(font);
		return style;
	}

	public static String getValue(XSSFCell xssfCell) {
		if (xssfCell == null || xssfCell.toString().trim().equals("")) {
			return "";
		}
		CellType cellTypeEnum = xssfCell.getCellTypeEnum();
		if (cellTypeEnum == CellType.NUMERIC) {
			if (HSSFDateUtil.isCellDateFormatted(xssfCell)) {
				return DateUtil.dateToString(xssfCell.getDateCellValue());
			} else {
				//防止数字变成科学计数法的形式
				DecimalFormat df = new DecimalFormat("0");
				return df.format(xssfCell.getNumericCellValue());
			}
		} else {
			return xssfCell.getStringCellValue();
		}
	}
}
