package com.zzsn.event.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.Event;
import com.zzsn.event.vo.*;

import java.util.Date;
import java.util.List;

/**
 * @Description: 事件
 * @Author: jeecg-boot
 * @Date: 2024-03-14
 * @Version: V1.0
 */
public interface IEventService extends IService<Event> {

    List<SubjectKafkaVo> progressList(Date disableDate);

    List<SubjectKafkaVo> eventSubjectList();

    /**
     * 获取事件详情
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2024/4/12
     */
    EventVO queryInfo(String eventId);

    /**
     * 分页列表-后台管理
     *
     * @param eventName 事件名称
     * @param eventType 事件分类id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param order     排序字段
     * @param orderType 排序方式
     * @param pageNo    偏移量
     * @param pageSize  返回条数
     * @author lkg
     * @date 2024/4/8
     */
    IPage<EventManageVO> pageList(String eventName, Integer eventType, Integer facePublic, Integer publishStatus, String startTime, String endTime,
                                  String order, String orderType, Integer pageNo, Integer pageSize);

    /**
     * 分页列表-门户(全部)
     *
     * @param projectId  项目id
     * @param eventName  事件名称
     * @param eventType  事件分类id
     * @param labelField 搜索字段
     * @param labelName  搜索词
     * @param order      排序字段
     * @param orderType  排序方式
     * @param pageNo     偏移量
     * @param pageSize   返回条数
     * @author lkg
     * @date 2024/4/8
     */
    IPage<EventFrontVO> frontAllPageList(String projectId, String eventId,String eventName, String eventType, String labelField, String labelName, String order, String orderType, Integer pageNo, Integer pageSize);

    /**
     * 分页列表-门户(我的)
     *
     * @param projectId  项目id
     * @param eventName  事件名称
     * @param eventType  事件分类id
     * @param labelField 搜索字段
     * @param labelName  搜索词
     * @param order      排序字段
     * @param orderType  排序方式
     * @param pageNo     偏移量
     * @param pageSize   返回条数
     * @author lkg
     * @date 2024/4/8
     */
    IPage<EventFrontVO> frontOwnerPageList(String projectId, String eventName, String eventType, String labelField, String labelName, String order, String orderType, Integer pageNo, Integer pageSize);


    /**
     * 分页列表(专题类别)-新平台管理
     *
     * @param subjectCondition 筛选条件
     * @param pageNo           当前页
     * @param pageSize         返回条数
     * @author lkg
     * @date 2024/4/28
     */
    Page<EventNewPlatVO> newPlatPageList(SubjectCondition subjectCondition, Integer pageNo, Integer pageSize);

    /**
     * 热点事件列表-前10
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param type      分类(1-按发布时间;2.按热度)
     * @param pageSize  返回条数
     * @author lkg
     * @date 2024/4/8
     */
    List<EventTopVO> topEventList(String projectId, String createBy,String startTime, String endTime, Integer type, Integer pageSize);

    /**
     * 根据地域获取事件信息列表
     *
     * @param type 地域类型(1-国际;2-国内)
     * @param name 地域名称
     * @author lkg
     * @date 2024/4/10
     */
    List<EventRegionVO> listByRegion(String projectId, String createBy,Integer type, String name);

    Event saveMain(AddEventParam addEventParam);

    void saveDefaultMap(String eventId);

    void updateMain(AddEventParam addEventParam);

    void deleteMain(String id);



    /**
     * 公开且发布的事件信息集合
     *
     * @param projectId   项目id
     * @param createBy    创建人
     * @param eventIdList 事件id集合
     * @param size        数量
     * @author lkg
     * @date 2024/4/10
     */
    List<EventExcelVO> frontAllList(String projectId, String createBy, List<String> eventIdList,String searchWord,
                                    String eventType, String labelField,String labelName, Integer size);

    /**
     * 默认创建的，公开且发布的事件信息集合
     *
     * @param projectId   项目id
     * @param createBy    创建人
     * @param eventIdList 事件id集合
     * @param size        数量
     * @author lkg
     * @date 2024/4/10
     */
    List<EventExcelVO> frontOwnerList(String projectId, String createBy, List<String> eventIdList,String searchWord,
                                      String eventType, String labelField,String labelName,  Integer size);

    /**
     * 模型信息列表
     *
     * @author lkg
     * @date 2024/4/11
     */
    List<ModelVO> modelList();

    /**
     * 获取事件信息集合
     *
     * @param eventIdList 事件id集合
     * @author lkg
     * @date 2024/4/12
     */
    List<EventVO> eventList(List<String> eventIdList);

    /**
     * 专题绑定关键词的id集合
     *
     * @param subjectIds 专题id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<String> bindKeyWordsIdList(List<String> subjectIds);
}
