package com.zzsn.event.util;

import com.aspose.words.*;
import org.apache.commons.lang3.SystemUtils;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;


/**
 * aspose 导出doc工具
 *
 * @author liuyang
 * @since 20201014
 */
public class DocUtil {

    private static final String fontsPath = "/usr/share/fonts";

    /**
     * 获取license
     *
     */
    public static void getLicense() {
        try {
            Resource resource = new ClassPathResource("license.xml");
            InputStream is = resource.getInputStream();
            License aposeLic = new License();
            aposeLic.setLicense(is);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * word文件流转成htm 内容
     *
     * @param inputStream
     * @return
     * @throws Exception
     */
    public static String convertDocStream2Html(InputStream inputStream) throws Exception {
        getLicense();
        Document doc = new Document(inputStream);
        HtmlSaveOptions saveOptions = new HtmlSaveOptions(SaveFormat.HTML);
        saveOptions.setExportHeadersFootersMode(ExportHeadersFootersMode.NONE); // HtmlSaveOptions的其他设置信息请参考相关API
        saveOptions.setCssStyleSheetType(CssStyleSheetType.INLINE);
        //指定是将字体资源导出到HTML，MHTML还是EPUB。默认值为false。
//        saveOptions.setFontsFolderAlias("font");
//        saveOptions.setFontSavingCallback(fontSavingArgs -> fontSavingArgs.getFontStream());
        //指定是否应使用Base64编码将字体资源嵌入HTML。默认值为false。
        saveOptions.setExportImagesAsBase64(true);
        //指定页面设置是导出到HTML，MHTML还是EPUB。默认值为false。
        saveOptions.setExportPageSetup(true);
        //指定在保存到HTML，MHTML或EPUB时是否应以相对单位输出字体大小。默认值为false。
//        saveOptions.setExportRelativeFontSize(true);
        //控制文本输入表单字段如何保存到HTML或MHTML。默认值为false。
        saveOptions.setExportTextInputFormFieldAsText(true);
        //如果为true，则在适用的情况下输出漂亮的格式。默认值为false。
//        saveOptions.setPrettyFormat(true);
        //获取或设置一个值，该值确定是否使用高质量（即慢速）渲染算法。(继承自SaveOptions)
        saveOptions.setUseHighQualityRendering(true);
//        saveOptions.setDocumentSplitCriteria(DocumentSplitCriteria.HEADING_PARAGRAPH);
        //控制如何将表格、行和单元格宽度导出为HTML、MHTML或EPUB。默认值为HtmlElementSizeOutputMode.ALL。该属性的值为HtmlElementSizeOutputMode整数常量。
        saveOptions.setTableWidthOutputMode(HtmlElementSizeOutputMode.RELATIVE_ONLY);
        saveOptions.setExportTocPageNumbers(true);
        //指定保存为HTML、MHTML或EPUB时是否规范化段落的负左缩进和负右缩进。默认值为false。
        saveOptions.setAllowNegativeIndent(true);
        //指定是否按Aspose缩放图像。导出到HTML、MHTML或EPUB时，文字的边界形状大小。默认值为true。
        saveOptions.setScaleImageToShapeSize(true);
        ByteArrayOutputStream htmlStream = new ByteArrayOutputStream();
        String htmlText = "";
        try {
            doc.save(htmlStream, saveOptions);
            htmlText = htmlStream.toString("UTF-8");
            htmlStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return htmlText;
    }

    /**
     * 根据html内容转为文件流
     *
     * @param content
     * @return
     * @throws Exception
     */
    public static byte[] convertDocHtml2Doc(String content) throws Exception {
        getLicense();
        if (SystemUtils.IS_OS_LINUX) {
            FontSettings fontSettings = new FontSettings();
            //true 表示递归查询子文件夹
            fontSettings.setFontsFolder(fontsPath, true);
        }
        Document doc = new Document();
        DataByteArrayOutputStream dataByteArrayOutputStream = new DataByteArrayOutputStream();
        DocumentBuilder builder = new DocumentBuilder(doc);
        builder.insertHtml(content);
        doc.save(dataByteArrayOutputStream, SaveFormat.DOCX);
        return dataByteArrayOutputStream.getData();
    }

    public static byte[] convertDocHtml2Pdf(String content) throws Exception {
        getLicense();
        if (SystemUtils.IS_OS_LINUX) {
            FontSettings fontSettings = new FontSettings();
            //true 表示递归查询子文件夹
            fontSettings.setFontsFolder(fontsPath, true);
        }
        Document doc = new Document();
        DataByteArrayOutputStream dataByteArrayOutputStream = new DataByteArrayOutputStream();
        DocumentBuilder builder = new DocumentBuilder(doc);
        builder.insertHtml(content);
        doc.save(dataByteArrayOutputStream, SaveFormat.PDF);
        return dataByteArrayOutputStream.getData();
    }

    /**
     * word转pdf  直接转
     *
     * @param wordInputStream 输入流
     * @param outputStream 输出流
     * @author lkg
     * @date 2025/9/16
     */
    public static void convertWordTo(InputStream wordInputStream, OutputStream outputStream,int saveFormat) throws Exception {
        getLicense();
        // 从输入流加载Word文档
        Document doc = new Document(wordInputStream);
        // 将文档保存到输出流（PDF）
        doc.save(outputStream, saveFormat);
    }
}
