package com.zzsn.event.task;

import com.zzsn.event.controller.EventLoginController;
import com.zzsn.event.service.EventLoginService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 研究中心登录用户，重新登录
 * @author wangFeng
 * @date 2024/10/22 14:24
 */
@Slf4j
@Component
public class RefreshLoginTask {
    @Resource
    private EventLoginService eventLoginService;

    @Scheduled(cron = "0 0/2 * * * ?")
    public void redoLogin() {
        log.info("研究中心事件用户重新登录");
        eventLoginService.redoLogin();
    }
}
