package com.zzsn.event.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson2.JSONObject;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.SysLoginModel;
import com.zzsn.event.service.EventLoginService;
import com.zzsn.event.util.RedisUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author wangFeng
 * @date 2024/10/22 14:29
 */
@Service
public class EventLoginServiceImpl implements EventLoginService {
    @Value("${spring.profiles.active:dev}")
    private String evn;
    @Value("${clbLogin.url}")
    private String loginUrl;
    @Resource
    private RedisUtil redisUtil;

    private Integer successCode = 200;
    public static final String CACHE_KEY = "event:sso:";

    @Override
    public Result<?> loginBS(SysLoginModel sysLoginModel) {
        String username = sysLoginModel.getUsername();
        String cacheKey = CACHE_KEY + evn + ":" +username;
        if (redisUtil.hasKey(cacheKey)) {
            Map<String, Object> cacheMap = (Map<String, Object>) redisUtil.get(cacheKey);
            SysLoginModel sysLoginModelCache = (SysLoginModel) cacheMap.get("sysLoginModel");
            if (sysLoginModelCache.getPassword().equals(sysLoginModel.getPassword())
                    && sysLoginModelCache.getCaptcha().equals(sysLoginModel.getCaptcha())
                    && sysLoginModelCache.getCheckKey().equals(sysLoginModel.getCheckKey())) {
                // 使用缓存
                Result loginResult = (Result) cacheMap.get("loginResult");
                return loginResult;
            }
            //信息变了就需要重新登录
            redisUtil.del(cacheKey);
        }
        return doClbLogin(sysLoginModel);
    }

    @Override
    public void redoLogin() {
        String cacheKey = CACHE_KEY + evn + ":*";
        ScanOptions options = ScanOptions.scanOptions().match(cacheKey).count(100).build();
        Cursor<String> scan = redisUtil.getRedisTemplate().scan(options);
        while (scan.hasNext()){
            String next = scan.next();
            Map<String, Object> cacheMap = (Map<String, Object>) redisUtil.get(next);
            SysLoginModel sysLoginModelCache = (SysLoginModel) cacheMap.get("sysLoginModel");
            doClbLogin(sysLoginModelCache);
        }
    }

    /**
     * 去克虏宝登录
     * @param sysLoginModel
     */
    public Result<?> doClbLogin(SysLoginModel sysLoginModel){
        Result<?> bean;
        try {
            String body = HttpRequest.post(loginUrl)
                    .header("content-type", "application/json;charset=UTF-8")
                    .body(JSONObject.toJSONString(sysLoginModel))
                    .execute().body();
            bean = JSONObject.parseObject(body, Result.class);
            if (successCode.equals(bean.getCode())) {
                String username = sysLoginModel.getUsername();
                String cacheKey = CACHE_KEY  + evn + ":" + username;
                // 调用成功
                Map<String, Object> cacheMap = new HashMap<>(2);
                cacheMap.put("sysLoginModel", sysLoginModel);
                cacheMap.put("loginResult", bean);
                redisUtil.set(cacheKey, cacheMap, 60 * 15);
            }
        } catch (Exception e) {
            bean = Result.FAIL();
        }
        return bean;
    }
}
