package com.zzsn.event.vo;

import lombok.Getter;
import lombok.Setter;

/**
 * 资讯搜索词
 *
 * @author lkg
 * @date 2024/12/25
 */
@Getter
@Setter
public class SearchWordVO {

    /**
     * 关键词检索范围(1-标题;2-正文;3-全文;4-来源)
     */
    private Integer searchScope;

    /**
     * 模糊/精确
     */
    private String searchAccuracy;

    /**
     * 搜索内容
     */
    private String searchInfo;

    /**
     * 多个搜索内容之间的关键词 AND、OR、NOT
     */
    private String searchLogicRelationship;

    /*-------------------一下参数--创建专题时使用-研究中心---------------------------*/
    /**关键词组id*/
    private String id;
    /**关键词组名称*/
    private String wordName;
    /**专题绑定关键词的绑定类型(1：绑定为采集词，2：绑定为过滤词，3绑定为排除词组)*/
    private String bindingType;
}
