package com.zzsn.event.kafka.producer;

import com.alibaba.fastjson.JSON;

import com.zzsn.event.vo.KeyWordsDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;

@Component
@Slf4j
@EnableBinding(IInfosourceSource.class)
public class ProduceInfo {

    @Autowired
    private IInfosourceSource source;

    /**
     * 关键词执行
     * @param keyWordsDTO 关键词信息源
     */
    public void sendKeyWordsInfoSourceMsg(KeyWordsDTO keyWordsDTO) {
        try{
            String msg = JSON.toJSONString(keyWordsDTO);
            Message<String> message = MessageBuilder.withPayload(msg).build();
            source.keyWordsCrawl().send(message);
        }catch (Exception e){
            e.printStackTrace();
            log.error("关键词："+ keyWordsDTO.getWordsCode() + "推送kafka失败");
        }
    }

}
