package com.zzsn.event.vo;

import lombok.Data;

import java.util.Date;

/**
 * @author lkg
 * @description: 专题列表信息封装-通过kafka发送给python
 * @date 2022/7/21
 */
@Data
public class SubjectKafkaVo {

    /*专题id*/
    private String id;
    /*专题名称*/
    private String subjectName;
    /*专题开始时间*/
    private Date timeEnable;
    /*专题结束*/
    private Date timeDisable;
    /*专题增量分析规则*/
    private Integer increAnaRule;
    /*专题总量分析规则*/
    private Integer totalAnaRule;
    /*专题时间间隔分析规则*/
    private Integer timeAnaRule;
    /*专题最近一次分析时间*/
    private Date analysisTime;
    /*分析事件脉络-最新资讯的时间*/
    private Date eventTime;
    /*关键词*/
    private String keyWord;
    /*es索引名*/
    private String indexName;
    /*es查询语句-查询所有*/
    private String query;
    /*es查询语句-查询前一天的数据*/
    private String beforeQuery;
    /*es查询语句-查询重复数据*/
    private String repeatNumQuery;
}
