package com.zzsn.event.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.event.entity.Event;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.vo.AddEventParam;
import com.zzsn.event.vo.KeyWordsPage;
import com.zzsn.event.vo.SubjectKafkaVo;

import java.util.Date;
import java.util.List;

/**
 * @Description: 事件
 * @Author: jeecg-boot
 * @Date:   2024-03-14
 * @Version: V1.0
 */
public interface IEventService extends IService<Event> {
    /**
     * 计算热度
     */
    void compute();

    List<SubjectKafkaVo> progressList(Date disableDate);

    List<SubjectKafkaVo> eventSubjectList();

    IPage<Event> pageList(Event event, Integer pageNo, Integer pageSize);

    void extractHotWords(AddEventParam event);

    Event saveMain(AddEventParam addEventParam);

    void updateMain(AddEventParam addEventParam);
    /**
     * 获取专题绑定的关键词组列表
     */
    List<KeyWordsPage> bindKeyWordsList(String id);
}
