package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.entity.Event;
import com.zzsn.event.enums.CodePrefixEnum;
import com.zzsn.event.mapper.EventMapper;
import com.zzsn.event.producer.ProduceInfo;
import com.zzsn.event.service.IEventService;
import com.zzsn.event.service.IKeyWordsService;
import com.zzsn.event.service.ISubjectKeywordsMapService;
import com.zzsn.event.service.ISubjectSearchEnginesMapService;
import com.zzsn.event.util.CodeGenerateUtil;
import com.zzsn.event.util.CronUtil;
import com.zzsn.event.util.HttpUtil;
import com.zzsn.event.util.RedisUtil;
import com.zzsn.event.vo.AddEventParam;
import com.zzsn.event.vo.KeyWordsDTO;
import com.zzsn.event.vo.KeyWordsPage;
import com.zzsn.event.vo.SubjectKafkaVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * @Description: 事件
 * @Author: jeecg-boot
 * @Date: 2024-03-14
 * @Version: V1.0
 */
@Service
public class EventServiceImpl extends ServiceImpl<EventMapper, Event> implements IEventService {
    @Value("${hotWords.extractUrl}")
    private String extractHotWordsUrl;
    @Autowired
    private CodeGenerateUtil codeGenerateUtil;
    @Autowired
    private IKeyWordsService iKeyWordsService;
    @Autowired
    private ISubjectSearchEnginesMapService iSubjectSearchEnginesMapService;

    @Autowired
    private ISubjectKeywordsMapService iSubjectKeywordsMapService;
    @Autowired
    private ProduceInfo produceInfo;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void compute() {
        //get the events need to compute
        List<Event> list = this.list(new LambdaQueryWrapper<Event>().eq(Event::getStatus, 1));
        for (Event event : list) {
            // latest week data

            // latest month data
            // latest year data
            // data before a year
        }
    }

    @Override
    public List<SubjectKafkaVo> progressList(Date disableDate) {
        return this.baseMapper.prosessList(disableDate);
    }

    @Override
    public List<SubjectKafkaVo> eventSubjectList() {
        return this.baseMapper.eventSubjectList(2);
    }

    @Override
    public IPage<Event> pageList(Event event, Integer pageNo, Integer pageSize) {
        Integer offset = (pageNo - 1) * pageSize;
        if (pageNo == 0) {
            offset = 0;
        }
        List<Event> pageList = baseMapper.pageList(event, offset, pageSize);
        //获取总条数
        Integer count = baseMapper.totalCount(event);
        IPage<Event> pageData = new Page<>(pageNo, pageSize, count);
        pageData.setRecords(pageList);
        return null;
    }

    @Override
    public void extractHotWords(AddEventParam event) {
        if (!StringUtils.isEmpty(event.getExtractHotWords()) && "1".equals(event.getExtractHotWords())) {
            Map<String, String> param = new HashMap<>();
            param.put("status", "0,1,2,3");
            param.put("timeFiled", "ALL");
            param.put("subjectId", event.getId());
            HttpUtil.doGet(extractHotWordsUrl, param, "utf-8");
        }
    }

    @Override
    public Event saveMain(AddEventParam addEventParam) {
        String cron = null;
        Event event = new Event();
        //事件专题的默认分析规则参数-必填
        BeanUtils.copyProperties(addEventParam, event);
        event.setIncreAnaRule(20);
        event.setTotalAnaRule(50);
        event.setTimeAnaRule(5);
        String subjectCode = codeGenerateUtil.geneCodeNo(CodePrefixEnum.SUBJECT_DEFAULT.getValue());
        event.setEventCode(subjectCode);
        cron = CronUtil.getRandomCron();
        event.setCron(cron);
        baseMapper.insert(event);
        return event;
    }

    @Override
    public void updateMain(AddEventParam addEventParam) {
        Event subject = new Event();
        BeanUtils.copyProperties(addEventParam, subject);
        //先记录老的信息状态
        Event oldSubject = baseMapper.selectById(subject.getId());
        baseMapper.updateById(subject);

        //判断开始时间和结束时间是否发生变动
        if ((StringUtils.isEmpty(addEventParam.getStartTime()) && StringUtils.isEmpty(oldSubject.getStartTime())) ||
                (!StringUtils.isEmpty(addEventParam.getStartTime()) && !StringUtils.isEmpty(oldSubject.getStartTime())
                        && oldSubject.getStartTime().compareTo(addEventParam.getStartTime()) == 0)) {

        } else {
            //查询出该专题绑定的关键词组
            List<KeyWordsPage> keyWordsPages = bindKeyWordsList(subject.getId());
            List<String> keyWordIds = new ArrayList<>();
            for (KeyWordsPage keyWordsPage : keyWordsPages) {
                keyWordIds.add(keyWordsPage.getId());
            }
            //更新redis中关键词时间
            updateRedisKeyWordsDate(addEventParam.getId(), keyWordIds);
        }
    }
    @Override
    public List<KeyWordsPage> bindKeyWordsList(String subjectId) {
        return iKeyWordsService.bindKeyWordsList(subjectId);
    }
    //更新专题绑定的关键词组的缓存信息
    private void updateRedisKeyWordsDate(String subjectId, List<String> keyWordsIds) {
        for (String keyWordsId : keyWordsIds) {
            KeyWordsDTO keyWordsDTO = iSubjectKeywordsMapService.selectMinByKeyWordsId(keyWordsId);
            KeyWordsDTO redisKeyWordsDTO = (KeyWordsDTO) redisUtil.get(Constants.KEY_WORDS_TO_REDIS_PREFIX + keyWordsDTO.getWordsCode());
            int count = iSubjectKeywordsMapService.selectCountByKeyWordsId(keyWordsId);
            KeyWordsDTO keyWordsDTO1;
            if (count <= 0) {
                keyWordsDTO1 = iSubjectKeywordsMapService.selectMaxByKeyWordsId(keyWordsId);
                redisKeyWordsDTO.setStartTime(keyWordsDTO.getStartTime());
                redisKeyWordsDTO.setEndTime(keyWordsDTO1.getEndTime());
            } else {
                if (redisKeyWordsDTO == null) {
                    redisKeyWordsDTO = keyWordsDTO;
                } else {
                    redisKeyWordsDTO.setEndTime(null);
                    redisKeyWordsDTO.setStartTime(keyWordsDTO.getStartTime());
                }
            }
            //查询出该专题绑定了哪些搜索引擎
            List<String> stringList = iSubjectSearchEnginesMapService.querySearchList(subjectId);
            redisKeyWordsDTO.setSearchEngines(stringList);
            redisUtil.set(Constants.KEY_WORDS_TO_REDIS_PREFIX + redisKeyWordsDTO.getWordsCode(), redisKeyWordsDTO);
            //立即执行一次
            produceInfo.sendKeyWordsInfoSourceMsg(redisKeyWordsDTO);
        }
    }

}
