package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.EventExtract;
import com.zzsn.event.entity.EventExtractTask;
import com.zzsn.event.mapper.EventExtractTaskMapper;
import com.zzsn.event.service.EventExtractService;
import com.zzsn.event.service.EventExtractTaskService;
import com.zzsn.event.service.OtherDataService;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.EventExtractTaskVO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
* @author lenovo
* @description 针对表【event_extract_task(事件抽取任务表)】的数据库操作Service实现
* @createDate 2024-09-13 11:31:47
*/
@Service
public class EventExtractTaskServiceImpl extends ServiceImpl<EventExtractTaskMapper, EventExtractTask>
    implements EventExtractTaskService{

    @Autowired
    private EventExtractService eventExtractService;
    @Autowired
    private OtherDataService otherDataService;

    @Override
    public IPage<EventExtractTaskVO> pageList(String projectId, String searchWord, String taskName, String startTime, String endTime, Integer pageNo, Integer pageSize) {
        int offset = (pageNo - 1) * pageSize;
        Long count = baseMapper.totalCount(projectId, searchWord, taskName, startTime, endTime);
        IPage<EventExtractTaskVO> pageData = new Page<>(pageNo, pageSize,count);
        if (count > 0) {
            List<EventExtractTaskVO> pageList = baseMapper.pageList(projectId, searchWord, taskName, startTime, endTime, offset, pageSize);

            List<String> taskIds = new ArrayList<>();
            Set<String> columnIds = new HashSet<>();
            pageList.forEach(e->{
                taskIds.add(e.getId());
                String columnId = e.getColumnId();
                Collections.addAll(columnIds, columnId.split(","));
            });
            // 任务数据范围(栏目名称)
            List<Node> columnList = otherDataService.columnList(new ArrayList<>(columnIds));
            Map<String, Node> columnMap = columnList.stream().collect(Collectors.toMap(Node::getId,Function.identity()));
            //任务抽取事件的数量统计
            Map<String, List<EventExtract>> map = new HashMap<>();
            List<EventExtract> eventExtractList = eventExtractService.list(Wrappers.<EventExtract>lambdaQuery().select(EventExtract::getTaskId, EventExtract::getCheckStatus)
                    .in(EventExtract::getTaskId, taskIds));
            if (CollectionUtils.isNotEmpty(eventExtractList)) {
                map = eventExtractList.stream().collect(Collectors.groupingBy(EventExtract::getTaskId));
            }
            for (EventExtractTaskVO taskVO : pageList) {
                //任务抽取事件的数量
                String taskId = taskVO.getId();
                List<EventExtract> eventExtracts = map.get(taskId);
                if (CollectionUtils.isNotEmpty(eventExtracts)) {
                    long noCheckCount = eventExtracts.stream().filter(e -> e.getCheckStatus() == 0).count();
                    taskVO.setExtractEventCount(eventExtracts.size());
                    taskVO.setNoCheckExtractEventCount((int)noCheckCount);
                } else {
                    taskVO.setExtractEventCount(0);
                    taskVO.setNoCheckExtractEventCount(0);
                }
                //数据范围
                String columnId = taskVO.getColumnId();
                StringBuilder stringBuilder = new StringBuilder();
                for (String s : columnId.split(",")) {
                    Node column = columnMap.get(s);
                    stringBuilder.append(",").append(column.getName());
                }
                taskVO.setColumnName(stringBuilder.substring(1));
            }
            pageData.setRecords(pageList);
        }
        return pageData;
    }
}




