package com.zzsn.event.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

@Data
public class SearchEnginesVo {
    /**主键*/
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**搜索引擎名称*/
    @Excel(name = "搜索引擎名称", width = 15)
    @ApiModelProperty(value = "搜索引擎名称")
    private String name;
    /**字典码*/
    @Excel(name = "字典码", width = 15)
    @ApiModelProperty(value = "字典码")
    private String dictionaryCode;
    /**引擎地址*/
    @Excel(name = "引擎地址", width = 15)
    @ApiModelProperty(value = "引擎地址")
    private String searchUrl;
    /**类别*/
    @Excel(name = "类别", width = 15, dicCode = "searchEngineType")
    @ApiModelProperty(value = "类别")
    private Integer type;
    /**使用状态*/
    @Excel(name = "使用状态", width = 15, dicCode = "use_status")
    @ApiModelProperty(value = "使用状态")
    private Integer status;
    /**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
    /**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
    /**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private String sysOrgCode;
    /**专题id*/
    private String subjectId;
    /**专题是否配置*/
    private String yn;
}
