package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
* 专题资讯用户筛选条件记录表
* @TableName subject_user_condition
*/
@Data
@TableName("subject_user_condition")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="SubjectUserCondition对象", description="专题资讯用户筛选条件记录表")
public class SubjectUserCondition implements Serializable {

    /**
    * 主键id
    */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**
    * 用户ID
    */
    @ApiModelProperty(value = "用户ID")
    private String userId;
    /**
    * 关联id
    */
    @ApiModelProperty(value = "关联ID")
    private String relationId;
    /**
    * 条件字符串
    */
    @ApiModelProperty(value = "条件字符串")
    private String jsonStr;
    /**
    * 创建时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

}
