package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @Description: 专题其他来源数据
 * @Author: jeecg-boot
 * @Date:   2023-10-26
 * @Version: V1.0
 */
@Data
@TableName("subject_addition")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="subject_addition对象", description="专题其他来源数据")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class SubjectAddition {

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
	private String id;
	/**专题id*/
	@Excel(name = "专题id", width = 15)
    @ApiModelProperty(value = "专题id")
	private String subjectId;
	/**关联id*/
	@Excel(name = "关联id", width = 15)
    @ApiModelProperty(value = "关联id")
	private String additionRelationId;
	/**类型 1专题  2人物  3政策 4企业 5企业标签*/
	@Excel(name = "类型", width = 15)
    @ApiModelProperty(value = "类型")
	private Integer additionType;
	@Excel(name = "企业数据类型[0-研报；1-年报；2-动态；3-公告]", width = 15)
	@ApiModelProperty(value = "企业数据类型[0-研报；1-年报；2-动态；3-公告]")
	private String additionDataType;
	@TableField(exist = false)
	private Integer enterpriseCheck;
	/**deleteFlag*/
	@Excel(name = "deleteFlag", width = 15)
    @ApiModelProperty(value = "deleteFlag")
	private Integer deleteFlag;
	/**创建人*/
	@Excel(name = "创建人", width = 15)
    @ApiModelProperty(value = "创建人")
	private String createBy;
	/**创建日期*/
	@Excel(name = "创建日期", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
	private Date createTime;
	/**更新人*/
	@Excel(name = "更新人", width = 15)
    @ApiModelProperty(value = "更新人")
	private String updateBy;
	/**更新日期*/
	@Excel(name = "更新日期", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
	private Date updateTime;

	@ApiModelProperty(value = "专题绑定的标签信息")
	//	来源专题的数据状态（0全部，1审核通过，2未审核，3暂定，4删除）
	private String labelConfiguration;
	@ApiModelProperty(value = "专题绑定的资讯状态")
	private String additionDataStatus;
	@ApiModelProperty(value = "扩充字段1")
	private String extend1;

	@TableField(exist = false)
	private List<String > additionRelationIdList;
	@TableField(exist = false)
	private List<SubjectConfiguration> subjectConfiguration;
	@ApiModelProperty(value = "专题绑定的划分专题库")
	private String additionPartitionLibrary;
	@TableField(exist = false)
	private List<SubjectLabel> subjectLabelList;


}
