package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.InfoSourceGroup;
import com.zzsn.event.vo.GroupTreeVO;
import com.zzsn.event.vo.InfoSourceGroupPage;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 信息源组表
 * @Author: jeecg-boot
 * @Date: 2021-11-25
 * @Version: V1.0
 */
@Mapper
public interface InfoSourceGroupMapper extends BaseMapper<InfoSourceGroup> {

    InfoSourceGroup selectGroupById(@Param("groupId") String groupId);

    /**
     * 获取信息源组下绑定的信息源id集合
     *
     * @param groupIds 信息源组id集合
     * @author lkg
     * @date 2024/12/18
     */
    List<String> selectInfoSourceByGroupIds(@Param("groupIds") List<String> groupIds);

    /**
     * 获取专题/事件下绑定的信息源组列表
     *
     * @param subjectId 专题/事件id
     * @param type 绑定类型
     * @author lkg
     * @date 2024/12/18
     */
    List<InfoSourceGroupPage> selectInfoSourceListById(@Param("subjectId") String subjectId, @Param("type") Integer type);


    /**
     * 信息源组和分类组成的树型结构
     *
     * @author lkg
     * @date 2024/12/23
     */
    List<GroupTreeVO> groupAndTypeTree();
}
