package com.zzsn.event.service;

import com.zzsn.event.entity.SubjectDictMap;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.SubjectBindLabelParam;

import java.util.List;

/**
* @author lenovo
* @description 针对表【subject_dict_map(专题-字典关系表)】的数据库操作Service
* @createDate 2025-03-28 11:56:32
*/
public interface SubjectDictMapService extends IService<SubjectDictMap> {

    /**
     * 专题绑定数据字典
     *
     * @param bindLabelParam 绑定参数
     * @author lkg
     * @date 2025/3/28
     */
    void modify(SubjectBindLabelParam bindLabelParam);

    /**
     * 专题绑定的数据字典信息
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/3/28
     */
    List<Node> boundList(String subjectId);
}
