package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SubjectSearchEnginesMap;
import com.zzsn.event.mapper.SubjectSearchEnginesMapMapper;
import com.zzsn.event.vo.SearchEnginesVo;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Description: 专题与搜索引擎关联表
 * @Author: jeecg-boot
 * @Date:   2022-06-21
 * @Version: V1.0
 */
@Service
public class SubjectSearchEnginesMapServiceImpl extends ServiceImpl<SubjectSearchEnginesMapMapper, SubjectSearchEnginesMap> implements ISubjectSearchEnginesMapService {

    @Override
    public void deleteBySubjectId(String subjectId){
        baseMapper.deleteBySubjectId(subjectId);
    }

    @Override
    public List<SearchEnginesVo> bindSearchEngineList(SearchEnginesVo searchEnginesVo){
        return baseMapper.bindSearchEngineList(searchEnginesVo);
    }

    @Override
    public List<String> querySearchList(String subjectId){
        return baseMapper.querySearchList(subjectId);
    }
}
