package com.zzsn.event.util;

import java.text.SimpleDateFormat;
import java.util.*;

public class DateUtil {

    static SimpleDateFormat format;

    public static String dateToString(Date date) {
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String getStringDate(Date date){

        String format = "yyyy-MM-dd";
        return DateUtil.format(date, format);
    }

    public static String format(Date d, String format)
    {
        if (d == null)
            return "";
        SimpleDateFormat myFormatter = new SimpleDateFormat(format);
        myFormatter.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        return myFormatter.format(d);
    }

    /**
     * 获取每天的开始时间 00:00:00:00
     *
     * @param date
     * @return
     */
    public static Date getStartTime(Date date) {
        Calendar dateStart = Calendar.getInstance();
        dateStart.setTime(date);
        dateStart.set(Calendar.HOUR_OF_DAY, 0);
        dateStart.set(Calendar.MINUTE, 0);
        dateStart.set(Calendar.SECOND, 0);
        return dateStart.getTime();
    }

    /**
     * 获取每天的结束时间 23:59:59:999
     *
     * @param date
     * @return
     */
    public static Date getEndTime(Date date) {
        Calendar dateEnd = Calendar.getInstance();
        dateEnd.setTime(date);
        dateEnd.set(Calendar.HOUR_OF_DAY, 23);
        dateEnd.set(Calendar.MINUTE, 59);
        dateEnd.set(Calendar.SECOND, 59);
        return dateEnd.getTime();
    }

    /**
     * 获取当前年份
     * @return
     */
    public static String getSysYear() {
        Calendar date = Calendar.getInstance();
        return String.valueOf(date.get(Calendar.YEAR));
    }

    /**
     * 获取当前时间所在日
     */
    public static Integer getDay(String dateStr) {
        Calendar instance = Calendar.getInstance();
        Date date = stringToDate(dateStr, "yyyy-MM-dd");
        instance.setTime(date);
        return instance.get(Calendar.DAY_OF_MONTH);
    }

    /**
     * 获取前一小时的时间
     * @param date 时间
     */
    public static Date beforeOneHour(Date date){
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(Calendar.HOUR_OF_DAY,-1);
        return instance.getTime();
    }

    public static Date stringToDate(String date,String formatStr) {
        Date parse = null;
        format = new SimpleDateFormat(formatStr);
        try {
            parse = format.parse(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return parse;
    }

    public static List<String> betweenDate(String startDate,String endDate) {
        List<String> dateList = new ArrayList<>();
        String formatStr = "yyyy-MM-dd";
        try {
            Date dayOne = stringToDate(startDate, formatStr);
            Date dayTwo = stringToDate(endDate, formatStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dayOne);
            dateList.add(startDate);
            while (dayTwo.after(calendar.getTime())) {
                calendar.add(Calendar.DAY_OF_MONTH,1);
                dateList.add(format(calendar.getTime(),formatStr));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return dateList;
    }

    /**
     * 获取天前凌晨时间
     * @param number 几天前
     */
    public static Date getSomeDayBegin(int number) {

        // 获取当前的日期和时间
        Calendar calendar = Calendar.getInstance();

        // 将当前的日期和时间减去一天
        calendar.add(Calendar.DAY_OF_MONTH, -number);

        // 将时间部分设置为凌晨时间
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        // 获取昨天凌晨时间
        return new Date(String.valueOf(calendar.getTime()));
    }
}
