package com.zzsn.event.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 数据生命周期 数据处理状态枚举<br>
 * 数据经过本阶段处理之后的状态
 *
 * @author 张宗涵
 * @date 2024/4/28
 */
@Getter
@AllArgsConstructor
public enum EnumHandlerStatus {
    UNKNOWN("未知"),


    CRAWLED("已采集"),


    PREPARE_HANDLED("已预处理"),
    TO_BASEDATA_FAILED("入采集库失败"),
    BASEDATA_INCLUDED("已入采集库"),


    SAVED("已保留"),
    FILTERED("已滤除"),
    TO_SUBJECT_MODEL_DISCARDED("入库模型已丢弃"),
    TO_SUBJECT_MQED("入库模型已发送"),
    TO_SUBJECT_MODEL_FAILED("入库模型处理失败"),
    TO_SUBJECT_MODELED("入库模型已处理"),
    TO_SUBJECT_FAILED("入专题库失败"),
    SUBJECT_INCLUDED("已入专题库"),
    ADD("新增"),


    DEEP_HANDLER_DISCARDED("深度处理已丢弃"),
    DEEP_HANDLER_MQED("深度处理已发送"),
    DEEP_HANDLER_FAILED("深度处理模型失败"),
    DEEP_HANDLER_MODIFIED("深度处理已处理"),
    DEEP_SUBJECT_MODIFIED("深度处理结果已入库"),
    DEEP_SUBJECT_FAILED("深度处理结果入库失败"),


    RETAINED("通过"),
    RETAIN_CANCELED("取消通过"),
    TEMPORARY("暂定"),
    DELETED("删除");


    private final String value;

    @JsonValue
    @Override
    public String toString() {
        return ordinal() + ":" + value;
    }
}
