package com.zzsn.event.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zzsn.event.entity.SubjectSampleFile;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 *  专题详情信息(包含样例文章)
 *
 * @author lkg
 * @date 2025/1/8
 */
@Data
public class SubjectSampleFileInfoVO {

    /**专题名称*/
    private String subjectName;
    /**专题描述*/
    private String remark;
    /**开始时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date timeEnable;
    /**结束时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date timeDisable;
    /**是否公开(0-未公开;1-已公开)*/
    private Integer facePublic;
    /**数据来源(0-平台数据;1-全网搜)*/
    private Integer dataSource;
    /**划分专题库*/
    private String library;

    /**专题分类名称*/
    private String subjectTypeName;
    /**专题下的样例文章*/
    private List<SubjectSampleFile> sampleFileList;
}
