package com.zzsn.event.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.InfoSourceGroup;
import com.zzsn.event.entity.SubjectInfoSourceMap;
import com.zzsn.event.enums.BindTypeEnum;
import com.zzsn.event.mapper.SubjectInfoSourceMapMapper;
import com.zzsn.event.service.ISubjectInfoSourceMapService;
import com.zzsn.event.service.InfoSourceGroupService;
import com.zzsn.event.service.ScoreModelService;
import com.zzsn.event.vo.InfoSourceGroupPage;
import com.zzsn.event.vo.ScoreModelVo;
import com.zzsn.event.vo.SubjectPage;
import com.zzsn.event.vo.SubjectStatisticsVo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description: 专题与信息源关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-09
 * @Version: V1.0
 */
@Service
public class SubjectInfoSourceMapServiceImpl extends ServiceImpl<SubjectInfoSourceMapMapper, SubjectInfoSourceMap> implements ISubjectInfoSourceMapService {


    @Autowired
    private InfoSourceGroupService infoSourceGroupService;
    @Autowired
    private ScoreModelService scoreModelService;

    @Override
    @Transactional
    public void delete(String subjectId){
        baseMapper.deleteBySubjectId(subjectId);
    }


    @Override
    public List<SubjectStatisticsVo> subjectRealBindInfoSources(List<String> subjectIds) {
        return baseMapper.subjectRealBindInfoSources(subjectIds);
    }

    @Override
    public List<String> subjectRealBindInfoSourceList(List<String> subjectIds) {
        return baseMapper.subjectRealBindInfoSourceList(subjectIds);
    }

    @Override
    public void updateMain(SubjectInfoSourceMap subjectInfoSourceMap){
        //更新信息源组信息权重
        baseMapper.updateById(subjectInfoSourceMap);
        //更新绑定的信息源权重(根据绑定的信息源组实现)
        baseMapper.infoSourceWeight(subjectInfoSourceMap.getSubjectId(), subjectInfoSourceMap.getSourceId(), subjectInfoSourceMap.getWeight());
    }

    @Override
    public void infoSourceBind(SubjectPage subjectPage) {
        List<String> idList = subjectPage.getInfoSourceIds();
        List<String> excludeIdList = subjectPage.getExcludeInfoSourceIds();
        List<SubjectInfoSourceMap> mapList = new ArrayList<>();
        /*定向组list*/
        List<String> directionaIds = subjectPage.getDirectionaIds();
        //判断是否全部绑定
        if (subjectPage.getYnAll()) {
            //获取所有的信息源组
            List<InfoSourceGroup> list = infoSourceGroupService.list();
            for (InfoSourceGroup infoSourceGroup : list) {
                SubjectInfoSourceMap subjectInfoSourceMap = new SubjectInfoSourceMap();
                subjectInfoSourceMap.setSourceId(infoSourceGroup.getId());
                subjectInfoSourceMap.setSubjectId(subjectPage.getId());
                subjectInfoSourceMap.setType(BindTypeEnum.INFO_SOURCE_GROUP.getvalue());
                mapList.add(subjectInfoSourceMap);
            }
            //判断打分模型信息源组处理(可以选择所有，则说明，之前理论上不存在信息源)
            List<ScoreModelVo> scoreModelList = scoreModelService.queryScoreModel(subjectPage.getId(), null);
            if (scoreModelList != null && scoreModelList.size() > 0) {
                for (ScoreModelVo scoreModelVo : scoreModelList) {
                    String typeId = scoreModelVo.getType();
                    JSONArray jsonArray = JSONArray.parseArray(scoreModelVo.getData().toString());
                    JSONObject jsonObject = jsonArray.getJSONObject(0);
                    JSONArray children = jsonObject.getJSONArray("children");
                    children.clear();
                    for (int i = 0; i < list.size(); i++) {
                        InfoSourceGroup group = list.get(i);
                        String newId = typeId + "-1-" + (i + 1);
                        JSONObject childJsonObject = new JSONObject();
                        childJsonObject.put("name", group.getGroupName());
                        childJsonObject.put("id", newId);
                        childJsonObject.put("infoSourceGroupId", group.getId());
                        childJsonObject.put("fraction", 80);
                        children.add(childJsonObject);
                    }
                    jsonObject.put("children", children);
                    jsonArray.remove(0);
                    jsonArray.add(0, jsonObject);
                    scoreModelVo.setData(jsonArray.toJSONString());
                    scoreModelVo.setChangeType(0);
                    //增加完之后，更新进去
                    scoreModelService.addOrUpdate(scoreModelVo,subjectPage.getCategory());
                }
            }
        } else {
            //判断是否有绑定信息源组
            if (idList != null && !idList.isEmpty()) {
                for (String infoSourceId : idList) {
                    SubjectInfoSourceMap subjectInfoSourceMap = new SubjectInfoSourceMap();
                    subjectInfoSourceMap.setSourceId(infoSourceId);
                    subjectInfoSourceMap.setSubjectId(subjectPage.getId());
                    subjectInfoSourceMap.setType(BindTypeEnum.INFO_SOURCE_GROUP.getvalue());
                    mapList.add(subjectInfoSourceMap);
                }
                //判断打分模型是否存在过，若存在则更改
                List<ScoreModelVo> scoreModelList = scoreModelService.queryScoreModel(subjectPage.getId(), null);
                if (scoreModelList != null && scoreModelList.size() > 0) {
                    for (ScoreModelVo scoreModelVo : scoreModelList) {
                        String typeId = scoreModelVo.getType();
                        JSONArray jsonArray = JSONArray.parseArray(scoreModelVo.getData().toString());
                        JSONObject jsonObject = jsonArray.getJSONObject(0);
                        JSONArray children = jsonObject.getJSONArray("children");
                        int count = children.size();
                        //判断是否存在节点（没有则直接添加）
                        if (count == 0) {
                            for (int i = 0; i < idList.size(); i++) {
                                InfoSourceGroup group = infoSourceGroupService.getGroupById(idList.get(i));
                                if (group != null) {
                                    String newId = typeId + "-1-" + (i + 1);
                                    JSONObject childJsonObject = new JSONObject();
                                    childJsonObject.put("name", group.getGroupName());
                                    childJsonObject.put("id", newId);
                                    childJsonObject.put("infoSourceGroupId", idList.get(i));
                                    childJsonObject.put("fraction", 80);
                                    children.add(childJsonObject);
                                }
                            }
                        } else {
                            String id = children.getJSONObject(count - 1).getString("id");
                            for (int i = 0; i < idList.size(); i++) {
                                InfoSourceGroup group = infoSourceGroupService.getGroupById(idList.get(i));
                                if (group != null) {
                                    String newId = typeId + "-1-" + (Integer.parseInt(id.substring(id.lastIndexOf("-") + 1)) + i + 1);
                                    JSONObject childJsonObject = new JSONObject();
                                    childJsonObject.put("name", group.getGroupName());
                                    childJsonObject.put("id", newId);
                                    childJsonObject.put("infoSourceGroupId", idList.get(i));
                                    childJsonObject.put("fraction", 80);
                                    children.add(childJsonObject);
                                }
                            }
                        }
                        jsonObject.put("children", children);
                        jsonArray.remove(0);
                        jsonArray.add(0, jsonObject);
                        scoreModelVo.setData(jsonArray.toJSONString());
                        scoreModelVo.setChangeType(0);
                        //增加完之后，更新进去
                        scoreModelService.addOrUpdate(scoreModelVo,subjectPage.getCategory());
                    }
                }
            }
            //判断是否排除信息源组
            if (excludeIdList != null && !excludeIdList.isEmpty()) {
                for (String infoSourceId : excludeIdList) {
                    SubjectInfoSourceMap subjectInfoSourceMap = new SubjectInfoSourceMap();
                    subjectInfoSourceMap.setSourceId(infoSourceId);
                    subjectInfoSourceMap.setSubjectId(subjectPage.getId());
                    subjectInfoSourceMap.setType(BindTypeEnum.EXCLUDE_INFO_SOURCE_GROUP.getvalue());
                    mapList.add(subjectInfoSourceMap);
                }

            }
            //定向信息源组
            if (directionaIds != null && !directionaIds.isEmpty()) {
                for (String infoSourceId : directionaIds) {
                    SubjectInfoSourceMap subjectInfoSourceMap = new SubjectInfoSourceMap();
                    subjectInfoSourceMap.setSourceId(infoSourceId);
                    subjectInfoSourceMap.setSubjectId(subjectPage.getId());
                    subjectInfoSourceMap.setType(BindTypeEnum.DIRECTIONA_INFO_SOURCE_GROUP.getvalue());
                    mapList.add(subjectInfoSourceMap);
                }
            }

        }
        this.saveBatch(mapList);
    }

    @Override
    public void deleteBind(SubjectPage subjectPage) {
        List<String> deleteInfoSourceIds = subjectPage.getInfoSourceIds();
        List<String> deleteExcludeInfoSourceIds = subjectPage.getExcludeInfoSourceIds();
        //定向信息源组
        List<String> directionaIds = subjectPage.getDirectionaIds();
        if (deleteInfoSourceIds != null && !deleteInfoSourceIds.isEmpty()) {
            baseMapper.deleteInfoSourceIds(subjectPage.getId(), deleteInfoSourceIds, BindTypeEnum.INFO_SOURCE_GROUP.getvalue());
            //获取该信息源组绑定的id
            List<String> infoSourceIdList = infoSourceGroupService.selectInfoSourceByGroupIds(deleteInfoSourceIds);
            if (infoSourceIdList != null && !infoSourceIdList.isEmpty()) {
                baseMapper.deleteInfoSourceIds(subjectPage.getId(), infoSourceIdList, BindTypeEnum.INFO_SOURCE.getvalue());
            }
            //更改打分模型中的信息源组绑定情况
            List<ScoreModelVo> scoreModelList = scoreModelService.queryScoreModel(subjectPage.getId(), null);
            for (String groupId : deleteInfoSourceIds) {
                for (ScoreModelVo scoreModel : scoreModelList) {
                    JSONArray jsonArray = JSONArray.parseArray(scoreModel.getData().toString());
                    JSONObject jsonObject = jsonArray.getJSONObject(0);
                    JSONArray children = jsonObject.getJSONArray("children");
                    //若信息源打分配置中已经存在的有相同的，则去除掉这部分
                    for (int i = 0; i < children.size(); i++) {
                        String infoSourceGroupId = children.getJSONObject(i).getString("infoSourceGroupId");
                        if (groupId.equals(infoSourceGroupId)) {
                            children.remove(i);
                            break;
                        }
                    }
                    jsonObject.put("children", children);
                    jsonArray.remove(0);
                    jsonArray.add(0, jsonObject);
                    scoreModel.setData(jsonArray.toJSONString());
                    scoreModel.setChangeType(0);
                    //去除完之后，更新进去
                    scoreModelService.addOrUpdate(scoreModel,subjectPage.getCategory());
                }
            }
        }
        if (deleteExcludeInfoSourceIds != null && deleteExcludeInfoSourceIds.size() > 0) {
            baseMapper.deleteInfoSourceIds(subjectPage.getId(), deleteExcludeInfoSourceIds, BindTypeEnum.EXCLUDE_INFO_SOURCE_GROUP.getvalue());
        }
        if (directionaIds != null && directionaIds.size() > 0) {
            baseMapper.deleteInfoSourceIds(subjectPage.getId(), directionaIds, BindTypeEnum.DIRECTIONA_INFO_SOURCE_GROUP.getvalue());
        }
    }

    @Override
    public JSONObject bindInfoSource(String subjectId) {
        List<InfoSourceGroupPage> infoSourceGroupList = infoSourceGroupService.bindInfoSourceList(subjectId);
        Map<Integer, List<InfoSourceGroupPage>> typeMap = infoSourceGroupList.stream().collect(Collectors.groupingBy(InfoSourceGroupPage::getSourceType));
        //绑定的信息源组
        List<InfoSourceGroupPage> bindList = typeMap.get(BindTypeEnum.INFO_SOURCE_GROUP.getvalue());
        if (CollectionUtils.isNotEmpty(bindList)) {
            for (InfoSourceGroupPage infoSourceGroupPage : bindList) {
                String weight = infoSourceGroupPage.getWeight();
                if (StringUtils.isNotEmpty(weight) && "0".equals(infoSourceGroupPage.getWeight())) {
                    infoSourceGroupPage.setWeight(null);
                }
            }
        }
        List<InfoSourceGroupPage> excludeList = typeMap.get(BindTypeEnum.EXCLUDE_INFO_SOURCE_GROUP.getvalue());
        List<InfoSourceGroupPage> directionalList = typeMap.get(BindTypeEnum.DIRECTIONA_INFO_SOURCE_GROUP.getvalue());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("bindList", CollectionUtils.isEmpty(bindList) ? new ArrayList<>() : bindList);
        jsonObject.put("excludeList", CollectionUtils.isEmpty(excludeList) ? new ArrayList<>() : excludeList);
        jsonObject.put("directionalList", CollectionUtils.isEmpty(directionalList) ? new ArrayList<>() : directionalList);
        return jsonObject;
    }

    @Override
    public void modifyInfoSourceInfo(InfoSourceGroupPage infoSourceGroupPage) {
        String subjectId = infoSourceGroupPage.getSubjectId();
        Integer sourceType = infoSourceGroupPage.getSourceType();
        String id = infoSourceGroupPage.getId();
        List<SubjectInfoSourceMap> list = this.list(Wrappers.<SubjectInfoSourceMap>lambdaQuery()
                .eq(SubjectInfoSourceMap::getSourceId, id)
                .eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                .eq(SubjectInfoSourceMap::getType, sourceType));
        if (CollUtil.isNotEmpty(list)){
            this.update(Wrappers.<SubjectInfoSourceMap>lambdaUpdate()
                    .set(ObjectUtil.isNotEmpty(infoSourceGroupPage.getIsExemptKeyword()),SubjectInfoSourceMap::getIsExemptKeyword,infoSourceGroupPage.getIsExemptKeyword())
                    .set(ObjectUtil.isNotEmpty(infoSourceGroupPage.getIsFreeCheck()),SubjectInfoSourceMap::getIsFreeCheck,infoSourceGroupPage.getIsFreeCheck())
                    .set(ObjectUtil.isNotEmpty(infoSourceGroupPage.getWeight()),SubjectInfoSourceMap::getWeight,infoSourceGroupPage.getWeight())
                    .eq(SubjectInfoSourceMap::getSourceId,id)
                    .eq(SubjectInfoSourceMap::getSubjectId,subjectId)
                    .eq(SubjectInfoSourceMap::getType,sourceType));
        }else {
            SubjectInfoSourceMap subjectInfoSourceMap = new SubjectInfoSourceMap();
            subjectInfoSourceMap.setSubjectId(subjectId);
            subjectInfoSourceMap.setSourceId(id);
            subjectInfoSourceMap.setType(sourceType);
            subjectInfoSourceMap.setWeight(infoSourceGroupPage.getWeight());
            subjectInfoSourceMap.setIsFreeCheck(infoSourceGroupPage.getIsFreeCheck());
            subjectInfoSourceMap.setIsExemptKeyword(infoSourceGroupPage.getIsExemptKeyword());
            this.save(subjectInfoSourceMap);
        }
    }
}
