package com.zzsn.event.config;

import com.zzsn.event.util.user.AuthUtil;
import com.zzsn.event.util.user.UserVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperMethod.ParamMap;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.*;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.*;

/**
 * mybatis拦截器，自动注入创建人、创建时间、修改人、修改时间
 *
 * @Author scott
 * @Date 2019-01-19
 */
@Slf4j
@Component
@Intercepts({@Signature(type = Executor.class, method = "update", args = {MappedStatement.class, Object.class})})
public class MybatisInterceptor implements Interceptor {

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement) invocation.getArgs()[0];
        String sqlId = mappedStatement.getId();
        log.debug("------sqlId------" + sqlId);
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        Object parameter = invocation.getArgs()[1];
        log.debug("------sqlCommandType------" + sqlCommandType);
        if (parameter == null) {
            return invocation.proceed();
        }
        String loginUsername = this.getLoginUsername();
        Date date = new Date();
        if (SqlCommandType.INSERT == sqlCommandType) {
            Field[] fields = getAllFields(parameter);
            for (Field field : fields) {
                String fieldName = field.getName();
                log.debug("------field.name------" + fieldName);
                if ("createBy".equals(fieldName)) {
                    field.setAccessible(true);
                    Object localCreateBy = field.get(parameter);
                    field.setAccessible(false);
                    if ((localCreateBy == null || localCreateBy.equals("")) && StringUtils.isNotBlank(loginUsername)) {
                        changeData(field, parameter, loginUsername);
                    }
                }
                // 注入创建时间
                if ("createTime".equals(fieldName)) {
                    field.setAccessible(true);
                    Object localCreateDate = field.get(parameter);
                    field.setAccessible(false);
                    if (localCreateDate == null || localCreateDate.equals("")) {
                        changeData(field, parameter, date);
                    }
                }
            }
        }
        if (SqlCommandType.UPDATE == sqlCommandType) {
            Field[] fields;
            if (parameter instanceof ParamMap) {
                ParamMap<?> p = (ParamMap<?>) parameter;
                if (p.containsKey("et")) {
                    parameter = p.get("et");
                } else {
                    parameter = p.get("param1");
                }
                if (parameter == null) {
                    return invocation.proceed();
                }
                fields = getAllFields(parameter);
            } else {
                fields = getAllFields(parameter);
            }
            for (Field field : fields) {
                String fieldName = field.getName();
                log.debug("------field.name------" + fieldName);
                if ("updateBy".equals(fieldName) && StringUtils.isNotBlank(loginUsername)) {
                    changeData(field, parameter, loginUsername);
                }
                if ("updateTime".equals(fieldName)) {
                    changeData(field, parameter, date);
                }
            }
        }
        return invocation.proceed();
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {
    }

    private String getLoginUsername() {
        String username = null;
        UserVo loginUser = AuthUtil.getLoginUser();
        if(loginUser != null){
            username = loginUser.getUsername();
        }
        return username;
    }

    //修改对应字段的值
    private void changeData(Field field, Object parameter,Object data){
        try {
            field.setAccessible(true);
            field.set(parameter,data);
            field.setAccessible(false);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private Field[] getAllFields(Object object) {
        Class<?> clazz = object.getClass();
        List<Field> fieldList = new ArrayList<>();
        while (clazz != null) {
            fieldList.addAll(new ArrayList<>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

}
