package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.vo.KeyWordsPage;
import com.zzsn.event.entity.KeyWords;
import com.zzsn.event.vo.KeywordsVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 关键词管理
 * @Author: jeecg-boot
 * @Date: 2021-11-26
 * @Version: V1.0
 */
@Mapper
public interface KeyWordsMapper extends BaseMapper<KeyWords> {

    List<KeyWordsPage> selectKeyWordsListById(@Param("subjectId") String subjectId);

    /**
     * 事件绑定关键词信息
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2024/9/12
     */
    KeywordsVO keywordInfoByEventId(@Param("eventId") String eventId);
}
