package com.zzsn.event.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.entity.EventCategory;
import com.zzsn.event.service.IEventCategoryService;
import com.zzsn.event.vo.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;

 /**
 * 事件分类
 * @Author: jeecg-boot
 * @Date:   2024-03-14
 * @Version: V1.0
 */
@Slf4j
@Api(tags="事件分类")
@RestController
@RequestMapping("/event/eventCategory")
public class EventCategoryController {
	@Autowired
	private IEventCategoryService eventCategoryService;
	
	/**
	 * 分页列表查询
	 *
	 * @param eventCategory
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@ApiOperation(value="事件分类-分页列表查询", notes="事件分类-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(EventCategory eventCategory,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<EventCategory> queryWrapper = new QueryWrapper<>();
		Page<EventCategory> page = new Page<EventCategory>(pageNo, pageSize);
		IPage<EventCategory> pageList = eventCategoryService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 * 添加
	 *
	 * @param eventCategory
	 * @return
	 */
	@ApiOperation(value="事件分类-添加", notes="事件分类-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody EventCategory eventCategory) {
		eventCategoryService.save(eventCategory);
		return Result.OK("添加成功！");
	}
	
	/**
	 * 编辑
	 *
	 * @param eventCategory
	 * @return
	 */
	@ApiOperation(value="事件分类-编辑", notes="事件分类-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody EventCategory eventCategory) {
		eventCategoryService.updateById(eventCategory);
		return Result.OK("编辑成功!");
	}
	
	/**
	 * 通过id删除
	 *
	 * @param id
	 * @return
	 */
	@ApiOperation(value="事件分类-通过id删除", notes="事件分类-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		eventCategoryService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 * 批量删除
	 *
	 * @param ids
	 * @return
	 */
	@ApiOperation(value="事件分类-批量删除", notes="事件分类-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.eventCategoryService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@ApiOperation(value="事件分类-通过id查询", notes="事件分类-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		EventCategory eventCategory = eventCategoryService.getById(id);
		return Result.OK(eventCategory);
	}




}
