package com.zzsn.event.service;

import com.zzsn.event.vo.CountVO;

import java.util.List;
import java.util.Map;

/**
 * es统计查询
 *
 * @author lkg
 * @date 2024/1/24
 */
public interface EsStatisticsService {


    /**
     * 总体分析，获取总量和波峰值
     *
     * @param subjectId 专题id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param type      1-按小时;2-按天
     * @author lkg
     * @date 2024/1/25
     */
    Map<String, String> totalAndMax(String subjectId, String startTime, String endTime, Integer type);


    /**
     * 情感判断分析
     *
     * @param subjectId 专题id
     * @param labelId   情感标签id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param type      1-按小时;2-按天
     * @author lkg
     * @date 2024/1/25
     */
    CountVO orientation(String subjectId, String labelId, String startTime, String endTime, Integer type);

    /**
     * 平台活跃度--前十
     *
     * @param subjectId 专题id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @author lkg
     * @date 2024/1/24
     */
    List<CountVO> origin(String subjectId, String startTime, String endTime);


    /**
     * 专题下的主流报道
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2024/1/29
     */
    String mainReport(String subjectId);

    /**
     * 专题信息传播走势
     *
     * @param subjectId 专题id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param type      1-按小时;2-按天
     * @author lkg
     * @date 2024/4/10
     */
    List<CountVO> flowData(String subjectId, String startTime, String endTime, Integer type);

    /**
     * 时间段内事件的信息总数
     *
     * @param eventIdList
     * @param startTime
     * @param endTime
     * @author lkg
     * @date 2024/4/10
     */
    long totalCount(List<String> eventIdList, String startTime, String endTime);
}
