package com.zzsn.event.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.EventExtract;
import com.zzsn.event.vo.EventExtractVO;

/**
* @author lenovo
* @description 针对表【event_extract(事件)】的数据库操作Service
* @createDate 2024-09-07 18:00:28
*/
public interface EventExtractService extends IService<EventExtract> {

    /**
     * 伪事件信息分页列表
     *
     * @param eventName 事件名称
     * @param eventType 时间分类
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param pageNo    当前页
     * @param pageSize  返回条数
     * @author lkg
     * @date 2024/9/9
     */
    IPage<EventExtractVO> pageList(String eventName, Integer eventType, String startTime, String endTime,
                                   Integer pageNo, Integer pageSize);
}
