package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * Description: 客户-数据权限关系表
 * Author: EDY
 * Date: 2023/8/1
 */
@Data
@TableName("customer_data_permission_map")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="customer_data_permission_map-客户-数据权限关系表", description="客户-数据权限关系表")
public class CustomerDataPermissionMap {
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键id")
    private String id;

    @ApiModelProperty(value = "客户id")
    private String customerId;

    @ApiModelProperty(value = "数据权限id")
    private String permissionId;

    @ApiModelProperty(value = "数据权限类型(project-项目;subject-专题;group-信息源组;keyword-关键词组;channel-栏目)")
    private String category;

    @ApiModelProperty(value = "创建人")
    private String createBy;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;
}
