package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.EventExtract;
import com.zzsn.event.service.EventExtractService;
import com.zzsn.event.mapper.EventExtractMapper;
import com.zzsn.event.vo.EventExtractVO;
import com.zzsn.event.vo.EventManageVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
* @author lenovo
* @description 针对表【event_extract(事件)】的数据库操作Service实现
* @createDate 2024-09-07 18:00:28
*/
@Service
public class EventExtractServiceImpl extends ServiceImpl<EventExtractMapper, EventExtract> implements EventExtractService{

    @Override
    public IPage<EventExtractVO> pageList(String eventName, Integer eventType, String startTime, String endTime, Integer pageNo, Integer pageSize) {
        int offset = (pageNo - 1) * pageSize;
        List<EventExtractVO> pageList = baseMapper.pageList(eventName, eventType, startTime, endTime, offset, pageSize);
        Long count = baseMapper.totalCount(eventName, eventType, startTime, endTime);
        IPage<EventExtractVO> pageData = new Page<>(pageNo, pageSize, count);
        pageData.setRecords(pageList);
        return pageData;
    }
}




