package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
* 挖掘到的事件
* @TableName event_extract
*/
@Data
@TableName("event_extract")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="event_extract对象", description="挖掘事件")
public class EventExtract implements Serializable {

    /**ID*/
    @TableId(value = "id",type = IdType.ASSIGN_ID)
    private String id;
    /**
    * 唯一id
    */
    @TableField("unique_id")
    private String uniqueId;
    /**
    * 名称
    */
    @TableField("event_name")
    private String eventName;
    /**
    * 事件类型
    */
    @TableField("event_type")
    private String eventType;
    /**
    * 开始时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("start_time")
    private Date startTime;
    /**
    * 结束时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("end_time")
    private Date endTime;
    /**
    * 自定义事件标签
    */
    @TableField("event_label")
    private String eventLabel;
    /**
    * 事件描述
    */
    @TableField("event_describe")
    private String eventDescribe;
    /**
    * 创建人id
    */
    @TableField("create_by")
    private String createBy;
    /**
    * 创建时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("create_time")
    private Date createTime;
}
