package com.zzsn.event.config.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 大模型配置参数
 * @author wangFeng
 * @date 2025/1/9 17:57
 */
@Data
@Component
@ConfigurationProperties(prefix = "model")
public class LlmProperties {
    private String defaultModelType;
    private List<ModelConfig> configs;

    @Data
    public static class ModelConfig{
        //模型类型
        private String modelType;
        //模型类型中文名称
        private String modelTypeName;
        //模型url
        private String url;
        //模型apiKey
        private String apiKey;
        //默认模型
        private String defaultModel;
        //是否开启网络搜索
        private Boolean webSearch;
        //温度
        private Float temperature;
    }

    /**
     * 根据模型类型获取模型配置
     *
     * @param modelType 模型类型
     * @author lkg
     * @date 2025/8/6
     */
    public ModelConfig getModelConfig(String modelType){
        for (ModelConfig config : configs) {
            if (config.getModelType().equals(modelType)){
                return config;
            }
        }
        return null;
    }
}
