package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.SubjectSearchEnginesMap;
import com.zzsn.event.vo.SearchEnginesVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 专题与搜索引擎关联表
 * @Author: jeecg-boot
 * @Date:   2022-06-21
 * @Version: V1.0
 */
@Mapper
public interface SubjectSearchEnginesMapMapper extends BaseMapper<SubjectSearchEnginesMap> {

    /**
     * 专题/事件绑定搜索引擎码集合
     *
     * @param subjectId 专题/事件id
     * @author lkg
     * @date 2024/12/18
     */
    List<String> querySearchList(@Param("subjectId") String subjectId);

    List<SearchEnginesVo>  bindSearchEngineList(@Param("searchEnginesVo") SearchEnginesVo searchEnginesVo);
}
