package com.zzsn.event.util.user;

/**
 * 用户信息
 *
 * @author lkg
 * @date 2023/4/12
 */
public abstract class UserUtil {

    UserUtil() {}

    private static final ThreadLocal<UserVo> USER_THREAD_LOCAL = new ThreadLocal<>();

    public static UserVo getLoginUser() {
        UserVo userVo = USER_THREAD_LOCAL.get();
        return userVo==null?new UserVo():userVo;
    }

    public static void setLoginUser(UserVo userVo) {
        USER_THREAD_LOCAL.set(userVo);
    }

    public static void removeUser() {
        USER_THREAD_LOCAL.remove();
    }
}
