package com.zzsn.event.util.user;

import cn.hutool.core.net.URLDecoder;
import com.alibaba.fastjson2.JSON;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;

/**
 * @Description: 获取用户登录信息
 * @Author: jeecg-boot
 * @Date:   2024-01-04
 * @Version: V1.0
 */
@Slf4j
@Data
public class AuthUtil {
	public final static String LOGIN_USER_HEADER = "loginUser";

	public static UserVo getLoginUser() {
		UserVo userVo = null;
		try {
			HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
			String userInfo = URLDecoder.decode(request.getHeader(LOGIN_USER_HEADER), StandardCharsets.UTF_8);
			userVo = JSON.parseObject(userInfo, UserVo.class);
		}catch (Exception e){
			log.debug("用户未登录");
		}
		if(userVo == null){
			userVo = new UserVo();
		}
		return userVo;
	}
	/**
	 * 检查是否可以访问
	 * @param code 服务编码
	 * @return null：无有效记录，true：可以访问，false：不能访问
	 */
	public static Boolean checkVisit(String code, HttpServletRequest request){
		return null;
	}


}
