package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.KeywordsType;
import com.zzsn.event.vo.KeywordsTypeVo;

import java.util.List;

/**
 * @Description: 关键词类别
 * @Author: jeecg-boot
 * @Date: 2021-12-01
 * @Version: V1.0
 */
public interface IKeywordsTypeService extends IService<KeywordsType> {

    /**
     * 根节点父ID的值
     */
    public static final String ROOT_PID_VALUE = "0";

    /**
     * 树节点有子节点状态值
     */
    public static final String HASCHILD = "1";

    /**
     * 树节点无子节点状态值
     */
    public static final String NOCHILD = "0";

    /**
     * 新增节点
     */
    void addKeywordsType(KeywordsType keywordsType);

    /**
     * 修改节点
     */
    void updateKeywordsType(KeywordsType keywordsType);

    /**
     * 删除节点
     */
    void deleteKeywordsType(String id);

    /**
     * 获取所有节点
     */
    List<KeywordsTypeVo> allList(Boolean contain, String subjectId, String bindingType);

    List<KeywordsTypeVo> listByParentIdAndSubjectId(String subjectId, String parentId);
}
