package com.zzsn.event.controller.reportData;

import lombok.Data;

/**
 * 报告资讯返回对象
 *
 * @author lkg
 * @date 2025/4/9
 */
@Data
public class ReportDataVO {

    //信息id
    private String id;
    //标题
    private String title;
    //摘要
    private String summary;
    //正文
    private String content;
    //带标签正文
    private String contentWithTag;
    //语言
    private String lang;
    //来源（信息来源）
    private String origin;
    //发布时间
    private String publishDate;
    //发布地址
    private String sourceAddress;
    //得分
    private Double score;
    //专题库类型(0: 其它 1：政策；2：领导讲话；3：专家观点；4：企业案例)
    private Integer classificationType;
    //删除标记(1:删除；0:保留)
    private Integer deleteFlag;
    //专题id
    private String subjectId;
    //专题名称
    private String subjectName;
    //审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0)
    private Integer checkStatus;
    /**原创性*/
    private String originality;
    //入库时间
    private String createDate;
}
