package com.zzsn.event.controller.eventExtract;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.EventExtractTask;
import com.zzsn.event.service.EventExtractTaskService;
import com.zzsn.event.service.OtherDataService;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.user.UserUtil;
import com.zzsn.event.util.user.UserVo;
import com.zzsn.event.vo.EventExtractTaskVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * 事件抽取任务
 *
 * @author lkg
 * @date 2024/9/13
 */
@RestController
@RequestMapping("/extract/task")
public class EventExtractTaskController {

    @Autowired
    private EventExtractTaskService eventExtractTaskService;
    @Autowired
    private OtherDataService otherDataService;

    /**
     * 事件抽取任务信息分页列表
     *
     * @param projectId  项目id
     * @param searchWord 搜索词
     * @param taskName   任务名称
     * @param startTime  开始时间
     * @param endTime    结束时间
     * @param pageNo     当前页
     * @param pageSize   返回条数
     * @author lkg
     * @date 2024/9/13
     */
    @GetMapping("/pageList")
    public Result<?> pageList(@RequestParam(required = false) String projectId,
                              @RequestParam(required = false) String searchWord,
                              @RequestParam(required = false) String taskName,
                              @RequestParam(required = false) String startTime,
                              @RequestParam(required = false) String endTime,
                              @RequestParam(defaultValue = "1") Integer pageNo,
                              @RequestParam(defaultValue = "10") Integer pageSize) {
        IPage<EventExtractTaskVO> page = eventExtractTaskService.pageList(projectId, searchWord, taskName, startTime, endTime, pageNo, pageSize);
        return Result.OK(page);
    }


    /**
     * 查看详情
     *
     * @param id 任务id
     * @author lkg
     * @date 2024/9/14
     */
    @GetMapping("/queryInfo")
    public Result<?> queryInfo(@RequestParam String id){
        EventExtractTask eventExtractTask = eventExtractTaskService.getById(id);
        return Result.OK(eventExtractTask);
    }

    /**
     * 新增/编辑
     *
     * @param eventExtractTask 事件抽取任务信息
     * @author lkg
     * @date 2024/9/13
     */
    @PostMapping("/modify")
    public Result<?> modify(@RequestBody EventExtractTask eventExtractTask) {
        UserVo currentUser = UserUtil.getLoginUser();
        eventExtractTask.setCreateBy(currentUser.getUsername());
        eventExtractTask.setCreateTime(new Date());
        eventExtractTaskService.saveOrUpdate(eventExtractTask);
        return Result.OK();
    }

    /**
     * 开启
     *
     * @param id 任务id
     * @author lkg
     * @date 2024/9/14
     */
    @GetMapping("/open")
    public Result<?> open(@RequestParam String id) {
        eventExtractTaskService.update(Wrappers.<EventExtractTask>lambdaUpdate().set(EventExtractTask::getTaskStatus, 1)
                .eq(EventExtractTask::getId, id));
        return Result.OK();
    }


    /**
     * 关闭
     *
     * @param id 任务id
     * @author lkg
     * @date 2024/9/14
     */
    @GetMapping("/close")
    public Result<?> close(@RequestParam String id) {
        eventExtractTaskService.update(Wrappers.<EventExtractTask>lambdaUpdate().set(EventExtractTask::getTaskStatus, 0)
                .eq(EventExtractTask::getId, id));
        return Result.OK();
    }

    /**
     * 删除
     *
     * @param id 任务id
     * @author lkg
     * @date 2024/9/13
     */
    @GetMapping("/delete")
    public Result<?> delete(@RequestParam String id) {
        eventExtractTaskService.update(Wrappers.<EventExtractTask>lambdaUpdate().eq(EventExtractTask::getId, id)
                .set(EventExtractTask::getDeleteStatus, 1));
        return Result.OK();
    }

    /**
     * 项目信息列表
     *
     * @author lkg
     * @date 2024/9/14
     */
    @GetMapping("/projectList")
    public Result<?> projectList() {
        List<Node> nodes = otherDataService.projectList();
        return Result.OK(nodes);
    }

    /**
     * 栏目信息列表
     *
     * @author lkg
     * @date 2024/9/14
     */
    @GetMapping("/columnList")
    public Result<?> columnList() {
        List<Node> nodes = otherDataService.columnList(null);
        return Result.OK(nodes);
    }


}
