package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.SubjectInfoSourceMap;


import java.util.List;

/**
 * @Description: 专题与信息源关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-09
 * @Version: V1.0
 */
public interface ISubjectInfoSourceMapService extends IService<SubjectInfoSourceMap> {

    /**
     * 根据专题id删除关联数据
     */
    void delete(String subjectId);

    /**
     * 根据专题ids批量删除
     */
    void deleteBySubjectIds(List<String> subjectIds);

    /**
     * 根据批量删除
     */
    void deleteInfoSourceIds(String subjectId, List<String> infoSourceIds, Integer type);

    /**
     * 根据专题查看绑定的信息源id
     */
    List<String> selectInfoSourceBySubject(List<String> subjectIds, Integer... type);


    /**
     * 根据信息源ids删除相应的映射关系
     * @param infoSourceIds
     */
    void deleteInfoSourceMapByInfoSourceIds(List<String> infoSourceIds);

    /**
     * 更新数据
     * @param subjectInfoSourceMap
     */
    void updateMain(SubjectInfoSourceMap subjectInfoSourceMap);

    /**
     * 根据信息源组id,查询出关联的专题id
     * @param infoSourceGroupId
     * @return
     */
    List<String> querySubjectIdsByGroupId(String infoSourceGroupId);

}
