package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lkg
 * @description: 专题分析表
 * @date 2022/7/14 17:10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName(value = "subject_analysis",autoResultMap = true)
public class SubjectAnalysis implements Serializable {

    /*主键id*/
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    /*专题id*/
    private String subjectId;
    /*资讯id*/
    private String dataId;
    /*标题*/
    private String title;
    /*来源*/
    private String origin;
    /*发布时间*/
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date publishDate;
    /*链接*/
    private String sourceAddress;
    /*重复数*/
    private Integer repeatNum;
    /*观点分析下的类型(1-新闻；2-论坛；3-微博)*/
    private Integer type;
    /*分类(1-观点分析；2-事件脉络；3-伪事件脉络)*/
    //伪事件脉络 即当事件脉络资讯数量少于约定数量，通过python算法生成临时的资讯数量大于/等于约定数量的事件脉络。
    private Integer category;
    /*分析时间*/
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date analysisDate;
    private String professionName;
}
