package com.zzsn.event.controller;

import com.zzsn.event.service.IEventService;
import com.zzsn.event.util.ExcelExportUtil;
import com.zzsn.event.vo.EventExcelVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 导出功能
 *
 * @author lkg
 * @date 2024/4/10
 */
@RestController
@RequestMapping("/export")
public class EventExportController {

    @Autowired
    private IEventService eventService;

    /**
     * 导出事件列表
     *
     * @param eventIdList 事件id集合
     * @param size        导出数量
     * @author lkg
     * @date 2024/4/10
     */
    @GetMapping("/eventList")
    public void exportEventList(@RequestParam(required = false) List<String> eventIdList,
                                @RequestParam(required = false) Integer size,
                                HttpServletResponse response) {
        String[] headers = new String[]{"id", "事件名称", "事件描述", "发布时间", "热度"};
        List<EventExcelVO> eventList = eventService.frontList(eventIdList, size);
        if (CollectionUtils.isNotEmpty(eventList)) {
            String name = "event.xlsx";
            List<List<String>> dataList = new ArrayList<>();
            eventList.forEach(e -> dataList.add(e.toList()));
            XSSFWorkbook workbook = ExcelExportUtil.exportExcelData(Arrays.asList(headers), dataList, "事件");
            try {
                setResponseHeader(response, name);
                ServletOutputStream outputStream = response.getOutputStream();
                workbook.write(outputStream);
                outputStream.flush();
                outputStream.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setResponseHeader(HttpServletResponse response, String name) {
        try {
            try {
                name = new String(name.getBytes(), "ISO8859-1");
            } catch (Exception e) {
                e.printStackTrace();
            }
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.setHeader("Content-Disposition", "attachment;filename=" + name);
            response.setHeader("Pargam", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
