package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 专题统计信息
 *
 * @author lkg
 * @date 2025/3/25
 */
@Data
@TableName("subject_statistic_info")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SubjectStatisticInfo {

    /**主键id*/
    private String subjectId;
    /**专题id*/
    private String id;
    /**信息总数量*/
    private Integer totalNum;
    /**待审核数量*/
    private Integer unCheckNum;
    /**绑定信息源数量*/
    private Integer bindSourceNum;
    /**绑定关键词组数量*/
    private Integer bindKeywordNum;
    /**最新数据日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date latestDataDate;
    /**更新时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    /**创建时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
}
