package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
* 事件脉络表
* @TableName event_context
*/
@Data
@TableName("event_context")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EventContext implements Serializable {

    /**
    * 主键id
    */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    /**
    * 专题id
    */
    private String eventId;
    /**
    * 资讯id
    */
    private String articleId;
    /**
    * 标题
    */
    private String title;
    /**
    * 来源
    */
    private String origin;
    /**
    * 发布时间
    */
    private String publishDate;
    /**
    * 链接
    */
    private String sourceAddress;
    /**
    * 排序
    */
    private Integer sortNumber;
    /**
    * 是否关键节点(1-是;0-否)
    */
    private Integer ynKeyNode;
    /**
    * 关键节点唯一编码
    */
    private String uniqueCode;
    /**
    * 上级id(所属关键节点id)
    */
    private String parentId;
    /**
    * es索引名称
    */
    private String esIndex;
    /**
    * 生成方式(1-自动;2-人工)
    */
    private Integer createWay;
    /**
    * 创建人
    */
    private String createBy;
    /**
    * 创建时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
    * 更新人
    */
    private String updateBy;
    /**
    * 更新时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;


    /**关键节点下资讯数量*/
    @TableField(exist = false)
    private Integer articleCount;
}
