package com.zzsn.event.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

@Data
public class KeyWordsPage {

    private String id;
    /**词组编码*/
    @Excel(name = "词组编码", width = 15)
    @ApiModelProperty(value = "词组编码")
    private String wordsCode;
    /**词组名称*/
    @Excel(name = "词组名称", width = 15)
    @ApiModelProperty(value = "词组名称")
    private String wordsName;

    /**词组类别id*/
    @Excel(name = "词组类别id", width = 15)
    @ApiModelProperty(value = "词组类别id")
    private String keyWordsTypeId;

    private String keyWordTypeNames;

    /**关键词*/
    @Excel(name = "关键词", width = 15)
    @ApiModelProperty(value = "关键词")
    private String keyWord;
    /**排除词*/
    @Excel(name = "排除词", width = 15)
    @ApiModelProperty(value = "排除词")
    private String exclusionWord;
    /**状态*/
    @Excel(name = "状态", width = 15, dicCode = "use_status")
    @ApiModelProperty(value = "状态")
    private String status;
    /**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
    /**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
    /**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private String sysOrgCode;

    /**今日采集数*/
    private Integer numToday;
    /**累计采集数*/
    private Integer numTotal;
    /**今日调度次数*/
    private Integer numDispatcherToday;
    /**累计调度次数*/
    private Integer numDispatcherTotal;
    /**成功调度次数*/
    private Integer numDispatcherSuccess;
    /**失败调度次数*/
    private Integer numDispatcherFailed;
    /**昨日采集数*/
    private Integer numYesterday;
    /**最近一次调度时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private java.util.Date latestDispatcherTime;
    /**最近一次采集时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private java.util.Date latestCollectionTime;

    /**说明 1信息源 2 关键词*/
    private String remark;

    /**专题绑定关键词时，关键词的采集方式（ 1：标题  2：正文  3：全文）*/
    private String type;

    /**专题绑定的关键词映射表主键id*/
    private String subjectKeyWordId;
    private String typeId;
}
