package com.zzsn.event.controller.eventExtract;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.EventExtract;
import com.zzsn.event.es.EsService;
import com.zzsn.event.service.EventExtractService;
import com.zzsn.event.vo.EventExtractVO;
import com.zzsn.event.vo.SubjectDataVo;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * @author lkg
 * @date 2024/9/7
 */
@Api(tags = "挖掘的事件管理")
@RestController
@RequestMapping("/extract")
public class EventExtractController {

    @Autowired
    private EventExtractService eventExtractService;
    @Autowired
    private EsService esService;

    /**
     * 伪事件信息分页列表
     *
     * @param taskId      任务id
     * @param searchWord  搜索词
     * @param eventName   事件名称
     * @param eventType   事件分类
     * @param startTime   开始时间
     * @param endTime     结束时间
     * @param checkStatus 审核状态(2-不通过;1-通过;0-待审核)
     * @param column      排序字段
     * @param sortType    排序方式
     * @param pageNo      偏移量
     * @param pageSize    返回条数
     * @author lkg
     * @date 2024/9/9
     */
    @GetMapping("/pageList")
    public Result<?> pageList(@RequestParam(name = "taskId") String taskId,
                              @RequestParam(name = "searchWord", required = false) String searchWord,
                              @RequestParam(name = "eventName", required = false) String eventName,
                              @RequestParam(name = "startTime", required = false) String startTime,
                              @RequestParam(name = "endTime", required = false) String endTime,
                              @RequestParam(name = "eventType", required = false) String eventType,
                              @RequestParam(name = "checkStatus", required = false) Integer checkStatus,
                              @RequestParam(name = "column", required = false) String column,
                              @RequestParam(name = "sortType", required = false) String sortType,
                              @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                              @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        IPage<EventExtractVO> page = eventExtractService.pageList(taskId, searchWord, eventName, startTime, endTime,
                eventType, checkStatus, column, sortType, pageNo, pageSize);
        return Result.OK(page);
    }

    /**
     * 伪事件来源资讯详情
     *
     * @param relatedIds 来源资讯id，多个逗号隔开
     * @author lkg
     * @date 2024/9/13
     */
    @GetMapping("/dataInfoList")
    public Result<?> dataInfoList(@RequestParam List<String> relatedIds) {
        List<SubjectDataVo> subjectDataVos = esService.listByIds(relatedIds);
        return Result.OK(subjectDataVos);
    }

    /**
     * 审核
     *
     * @param eventExtract 伪事件信息
     * @author lkg
     * @date 2024/9/13
     */
    @PostMapping("/modify")
    public Result<?> modify(@RequestBody EventExtract eventExtract) {
        eventExtractService.updateById(eventExtract);
        return Result.OK();
    }


    /**
     * 删除
     *
     * @param id 主键id
     * @author lkg
     * @date 2024/9/9
     */
    @GetMapping("/delete")
    public Result<?> delete(@RequestParam String id) {
        eventExtractService.update(Wrappers.<EventExtract>lambdaUpdate().set(EventExtract::getDeleteStatus, 1)
                .eq(EventExtract::getId, id));
        return Result.OK();
    }


}
