package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Description: 信息源组表
 * @Author: jeecg-boot
 * @Date:   2021-11-25
 * @Version: V1.0
 */
@Data
@TableName("info_source_group")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class InfoSourceGroup implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    private String id;
	/**组编码*/
    private String groupCode;
	/**信息源组名称*/
    private String groupName;
	/**分组说明*/
    private String groupRemark;
    /**状态*/
    private Integer status;


    /**分类id，逗号拼接*/
    @TableField(exist = false)
    private String groupTypeIds;

}
