package com.zzsn.event.util;

import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.stream.Stream;

/**
 * @author lkg
 * @description: 指标值计算
 * @date 2023/6/19
 */
public class CalculateUtil {

    private static final List<String> list = Arrays.asList("-","--");
    /**
     * 加法
     * @param param1 参数1
     * @param param2 参数2
     * @return java.lang.String
     */
    public static String add(String param1,String param2){
        String data = null;
        if (!list.contains(param1) && !list.contains(param2)){
            if (StringUtils.isEmpty(param1)) {
                param1 = "0";
            }
            if (StringUtils.isEmpty(param2)) {
                param2 = "0";
            }
            BigDecimal bd1 = new BigDecimal(param1);
            BigDecimal bd2 = new BigDecimal(param2);
            BigDecimal add = bd1.add(bd2);
            if (add.compareTo(BigDecimal.ZERO) != 0) {
                data = add.toString();
            }
        }
        return data;
    }

    /**
     * 减法
     * @param param1 参数1
     * @param param2 参数2
     * @return java.lang.String
     */
    public static String subtract(String param1,String param2){
        String data = null;
        if (!list.contains(param1) && !list.contains(param2) ){
            if (StringUtils.isEmpty(param1)) {
                param1 = "0";
            }
            if (StringUtils.isEmpty(param2)) {
                param2 = "0";
            }
            BigDecimal bd1 = new BigDecimal(param1);
            BigDecimal bd2 = new BigDecimal(Objects.requireNonNull(param2));
            BigDecimal subtract = bd1.subtract(bd2);
            if (subtract.compareTo(BigDecimal.ZERO) != 0) {
                data = subtract.toString();
            }
        }
        return data;
    }

    /**
     * 乘法
     * @param param1 参数1
     * @param param2 参数2
     * @return java.lang.String
     */
    public static String multiply(String param1,String param2){
        if(StringUtils.isNotEmpty(param1)&& StringUtils.isNotEmpty(param2)){
            if (!list.contains(param1) && !list.contains(param2) ){
                BigDecimal bd1 = new BigDecimal(param1);
                BigDecimal bd2 = new BigDecimal(param2);
                BigDecimal multiply = bd1.multiply(bd2);
                return multiply.setScale(2,RoundingMode.HALF_UP).toString();
            }
        }
        return null;
    }

    /**
     * 除法-固定精度(默认保留小数点后四位)
     * @param param1 参数1
     * @param param2 参数2
     * @return java.lang.String
     */
    public static String divide(String param1,String param2){
        if(StringUtils.isNotEmpty(param1)&& StringUtils.isNotEmpty(param2)){
            if (!list.contains(param1) && !list.contains(param2) ){
                BigDecimal bd2 = new BigDecimal(param2);
                if (bd2.compareTo(BigDecimal.ZERO)==0){
                    return null;
                }else {
                    BigDecimal bd1 = new BigDecimal(param1);
                    BigDecimal divide = bd1.divide(bd2,4, RoundingMode.HALF_UP);
                    return divide.toString();
                }
            }
        }
        return null;
    }

    /**
     * 除法-控制精度
     * @param param1 参数1
     * @param param2 参数2
     * @param num 精确到小数点后几位
     * @return java.lang.String
     */
    public static String divide(String param1,String param2,int num){
        if(StringUtils.isNotEmpty(param1)&& StringUtils.isNotEmpty(param2)){
            if (!list.contains(param1) && !list.contains(param2) ){
                BigDecimal bd2 = new BigDecimal(param2);
                if (bd2.compareTo(BigDecimal.ZERO)==0){
                    return null;
                }else {
                    BigDecimal bd1 = new BigDecimal(param1);
                    BigDecimal divide = bd1.divide(bd2,num, RoundingMode.HALF_UP);
                    return divide.toString();
                }
            }
        }
        return null;
    }

    /**
     * 转换百分比
     * @param param 参数1
     * @return java.lang.String
     */
    public static String percentage(Double param){
        if(param!=null){
            DecimalFormat decimalFormat = new DecimalFormat("0.00%");
            return decimalFormat.format(param);
        }
        return null;
    }

    /**
     * 转换百分比
     *
     * @param param 参数
     * @param flag  转换后是否要小数
     * @return java.lang.String
     */
    public static String percentage(Double param, Boolean flag) {
        if (param != null) {
            String pattern = "0%";
            if (flag) {
                pattern = "0.00%";
            }
            DecimalFormat decimalFormat = new DecimalFormat(pattern);
            return decimalFormat.format(param);
        }
        return null;
    }

    /**
     * 平均数
     * @param param1 参数1
     * @param param2 参数2
     * @return java.lang.String
     */
    public static String average(String param1,String param2){
        if(StringUtils.isNotEmpty(param1)&& StringUtils.isNotEmpty(param2)){
            if (!list.contains(param1) && !list.contains(param2) ){
                BigDecimal bd1 = new BigDecimal(param1);
                BigDecimal bd2 = new BigDecimal(param2);
                OptionalDouble average = Stream.of(bd1, bd2).mapToDouble(BigDecimal::doubleValue).average();
                if (average.isPresent()){
                    return String.valueOf(average.getAsDouble());
                }
            }
        }
        return null;
    }

    /**
     * 绝对值
     * @param param1 参数1
     * @return java.lang.String
     */
    public static String abs(String param1){
        if(StringUtils.isNotEmpty(param1)){
            if (!list.contains(param1) ){
                BigDecimal bd1 = new BigDecimal(param1);
                return bd1.abs().toString();
            }
        }
        return null;
    }
}
