package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.SubjectSearchEnginesMap;
import com.zzsn.event.vo.SearchEnginesVo;

import java.util.List;

/**
 * @Description: 专题与搜索引擎关联表
 * @Author: jeecg-boot
 * @Date:   2022-06-21
 * @Version: V1.0
 */
public interface ISubjectSearchEnginesMapService extends IService<SubjectSearchEnginesMap> {

    void deleteBySubjectId(String subjectId);

    List<SearchEnginesVo> bindSearchEngineList(SearchEnginesVo searchEnginesVo);

    /**
     * 根据专题id查询出专题绑定的搜索引擎编码
     * @param subjectId
     * @return
     */
    List<String> querySearchList(String subjectId);
}
