package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.ClbFileOperationLog;
import com.zzsn.event.entity.ClbFileOperationLogDetails;
import com.zzsn.event.mapper.ClbFileOperationLogMapper;
import com.zzsn.event.service.IClbFileOperationLogDetailsService;
import com.zzsn.event.service.IClbFileOperationLogService;
import com.zzsn.event.util.user.UserVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Slf4j
public class ClbFileOperationLogServiceImpl extends ServiceImpl<ClbFileOperationLogMapper, ClbFileOperationLog> implements IClbFileOperationLogService {

    @Autowired
    IClbFileOperationLogDetailsService detailsService;

    @Override
    public ClbFileOperationLog operationStart(UserVo userVo) {
        ClbFileOperationLog clbFileOperationLog = new ClbFileOperationLog();
        clbFileOperationLog.setOperationUserId(userVo.getId());
        clbFileOperationLog.setUserName(userVo.getUsername());
        clbFileOperationLog.setUserCnName(userVo.getRealname());
        clbFileOperationLog.setProcessing("50%");
        super.save(clbFileOperationLog);
        return clbFileOperationLog;
    }

    @Override
    public ClbFileOperationLog operationStart(String fileName, UserVo userVo) {
        ClbFileOperationLog clbFileOperationLog = new ClbFileOperationLog();
        clbFileOperationLog.setOperationUserId(userVo.getId());
        clbFileOperationLog.setUserName(userVo.getUsername());
        clbFileOperationLog.setUserCnName(userVo.getRealname());
        clbFileOperationLog.setFileName(fileName);
        clbFileOperationLog.setProcessing("50%");
        super.save(clbFileOperationLog);
        return clbFileOperationLog;
    }

    @Override
    public void failure(String fileName, String fileUrl, String desc,UserVo userVo) {
        super.save(new ClbFileOperationLog()
                .setOperationUserId(userVo.getId())
                .setUserName(userVo.getUsername())
                .setUserCnName(userVo.getRealname())
                .setOperationType(0)
                .setFileName(fileName)
                .setFileUrl(fileUrl)
                .setProcessing("0%")
                .setGlobalFailure(1)
                .setGlobalFailureDesc(desc)
                .setCreateTime(new Date())
        );
    }

    @Override
    public void saveEntity(ClbFileOperationLog clbFileOperationLog) {
        List<ClbFileOperationLogDetails> list = clbFileOperationLog.getClbFileOperationLogDetails();
        List<ClbFileOperationLogDetails> succ = list.stream().filter(e -> e.getOperationStatus() == 0).collect(Collectors.toList());
        List<ClbFileOperationLogDetails> faild = list.stream().filter(e -> e.getOperationStatus() == 1).collect(Collectors.toList());
        clbFileOperationLog.setFailCount(faild.size());
        clbFileOperationLog.setSuccessCount(succ.size());
        clbFileOperationLog.setOperationStatus(1);
        clbFileOperationLog.setProcessing("100%");
        clbFileOperationLog.setUpdateTime(new Date());
        super.updateById(clbFileOperationLog);
        list.forEach(e -> e.setFileOperationId(clbFileOperationLog.getId()));
        detailsService.saveBatch(list);
    }
}
