package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author obcy
 * @since 2024-08-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("clb_label")
public class ClbLabel extends Model<ClbLabel> {

    private static final long serialVersionUID = 1L;

    /**
     * 标签表id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建日期
     */
    @TableField("create_time")
    private Date createTime;

    /**
     * 更新人
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 更新日期
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 实体id
     */
    @TableField("entity_object_id")
    private String entityObjectId;

    /**
     * 所属类目id
     */
    @TableField("label_type_id")
    private String labelTypeId;

    /**
     * 标签类别（字典维护）
     */
    @TableField("label_category")
    private String labelCategory;

    /**
     * 标签名称
     */
    @TableField("label_name")
    private String labelName;

    /**
     * 是否互斥（1互斥（默认），0不互斥）
     */
    @TableField("is_mutual_exclusion")
    private String isMutualExclusion;

    /**
     * 标签描述
     */
    @TableField("label_desc")
    private String labelDesc;

    /**
     * 标签状态(1开启，0关闭)
     */
    @TableField("label_status")
    private Integer labelStatus;

    /**
     * 标签编码
     */
    @TableField("label_code")
    private String labelCode;
    /**
     * 数据字典编码
     */
    @TableField("dict_code")
    private String dictCode;

    /**
     * 业务口径（1自定义，2实体表引用，3字典引用）
     */
    @TableField("business_caliber")
    private Integer businessCaliber;

    /**
     * 标签对应的任务id
     */
    @TableField(exist = false)
    private String taskId;
    /**
     * 任务计划描述
     */
    @TableField(exist = false)
    private String planDescription;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
