package com.zzsn.event.controller.common;

import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.Event;
import com.zzsn.event.entity.EventLlmConfig;
import com.zzsn.event.enums.AnalysisColumnEnum;
import com.zzsn.event.service.AnalysisService;
import com.zzsn.event.service.EventAnalysisVersionRecordService;
import com.zzsn.event.service.EventLlmConfigService;
import com.zzsn.event.service.IEventService;
import com.zzsn.event.vo.EventLlmConfigModifyVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 大模型配置
 *
 * @author lkg
 * @date 2025/7/28
 */
@Slf4j
@RestController
@RequestMapping("/llm/config")
public class LLmConfigController {

    @Autowired
    private EventLlmConfigService llmConfigService;
    @Autowired
    private AnalysisService analysisService;
    @Autowired
    private EventAnalysisVersionRecordService eventAnalysisVersionRecordService;
    @Autowired
    private IEventService eventService;

    /**
     * 事件下大模型配置信息
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2025/7/28
     */
    @GetMapping("/list")
    public Result<?> list(@RequestParam String eventId) {
        List<EventLlmConfig> configList = llmConfigService.getConfigList(eventId);
        return Result.OK(configList);
    }

    /**
     * 批量编辑事件的大模型配置信息
     *
     * @param eventLlmConfigList 大模型配置信息
     * @author lkg
     * @date 2025/7/28
     */
    @PostMapping("/modifyBatch")
    public Result<?> modifyBatch(@RequestBody List<EventLlmConfig> eventLlmConfigList) {
        llmConfigService.modifyBatch(eventLlmConfigList);
        return Result.OK();
    }
    /**
     * 编辑事件栏目的大模型配置信息,同时触发大模型更新结果
     *
     * @param eventLlmConfigModifyVO 大模型配置信息
     * @author lkg
     * @date 2025/7/28
     */
    @PostMapping("/modifySingle")
    public Result<?> modifySingle(@RequestBody EventLlmConfigModifyVO eventLlmConfigModifyVO) {
        String llmResult = null;
        String versionId = eventLlmConfigModifyVO.getVersionId();
        if (StringUtils.isEmpty(versionId)) {
            return Result.FAIL("请选择要修改的版本");
        }
        EventLlmConfig eventLlmConfig = new EventLlmConfig();
        BeanUtils.copyProperties(eventLlmConfigModifyVO, eventLlmConfig);
        llmConfigService.modifySingle(eventLlmConfig);
        AnalysisColumnEnum analysisColumnEnum = AnalysisColumnEnum.getByCode(eventLlmConfig.getColumnCode());
        if (analysisColumnEnum != null) {
            String eventId = eventLlmConfig.getEventId();
            Event event = eventService.getById(eventId);
            String eventName = event.getEventName();
            String content  = "事件标题；" + eventName + "\n事件摘要:" + event.getEventDescribe();
            //调用大模型更细结果
            llmResult = analysisService.llmResult(eventId,content, null, null, eventLlmConfig.getColumnCode());
            log.info("{}-事件分析【{}】重新生成逻辑完成。", eventName, analysisColumnEnum.getName());
        } else {
            log.info("未找到对应的事件栏目【{}】", eventLlmConfig.getColumnCode());
        }
        //更新返回结果
        eventAnalysisVersionRecordService.modify(versionId, analysisColumnEnum, llmResult);
        return Result.OK(llmResult);
    }
}
